/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item.impl;

import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.network.UpdateBlockColorPacket;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import org.jetbrains.annotations.Nullable;

public interface IPaintToolApplier {
    default public ActionResultType usePaintTool(ItemUseContext context) {
        if (!this.shouldUseTool(context)) {
            return ActionResultType.PASS;
        }
        TileEntity blockEntity = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (blockEntity == null) {
            return ActionResultType.PASS;
        }
        IPaintToolSelector selector = this.createPaintToolSelector(blockEntity, context);
        IPaintToolAction action = null;
        if (selector != null) {
            action = this.createPaintToolAction(context);
        }
        if (selector == null || action == null) {
            return ActionResultType.PASS;
        }
        CubePaintingEvent event = new CubePaintingEvent(selector, action);
        CubeChangesCollector collector = new CubeChangesCollector(context.func_195991_k());
        if (event.prepare(collector, context)) {
            event.apply(collector, context);
            UpdateBlockColorPacket packet = new UpdateBlockColorPacket(context, event);
            NetworkManager.sendToServer(packet);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public IPaintToolAction createPaintToolAction(ItemUseContext var1);

    @Nullable
    public IPaintToolSelector createPaintToolSelector(ItemUseContext var1);

    @Nullable
    default public IPaintToolSelector createPaintToolSelector(TileEntity blockEntity, ItemUseContext context) {
        if (blockEntity instanceof IPaintToolSelector.Provider) {
            IPaintToolSelector.Provider provider = (IPaintToolSelector.Provider)blockEntity;
            return provider.createPaintToolSelector(context);
        }
        if (blockEntity instanceof IBlockPaintable) {
            return this.createPaintToolSelector(context);
        }
        return null;
    }

    public boolean shouldUseTool(ItemUseContext var1);
}

