/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class AdvancedExportPacket
extends CustomPacket {
    private final BlockPos pos;
    private final CompoundNBT profileTag;

    public AdvancedExportPacket(AdvancedBuilderBlockEntity blockEntity, CompoundNBT profileTag) {
        this.pos = blockEntity.func_174877_v();
        this.profileTag = profileTag;
    }

    public AdvancedExportPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.profileTag = buffer.readNbt();
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeNbt(this.profileTag);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        AdvancedBuilderBlockEntity blockEntity1;
        block5: {
            block4: {
                TileEntity blockEntity = player.func_71121_q().func_175625_s(this.pos);
                if (!(blockEntity instanceof AdvancedBuilderBlockEntity)) break block4;
                blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
                if (player.field_71070_bA instanceof AdvancedBuilderMenu) break block5;
            }
            this.abort((PlayerEntity)player, "unauthorized", "user status is incorrect");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_EXPORT.accept((PlayerEntity)player)) {
            this.abort((PlayerEntity)player, "export", "prohibited by the config file");
            return;
        }
        GameProfile profile = DataSerializers.readGameProfile(this.profileTag);
        this.accept((PlayerEntity)player, "export");
        blockEntity1.exportFromDocument(player, profile);
    }

    private void accept(PlayerEntity player, String op) {
        String playerName = player.func_195047_I_();
        ModLog.info("accept {} request of the '{}'", op, playerName);
    }

    private void abort(PlayerEntity player, String op, String reason) {
        String playerName = player.func_195047_I_();
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, playerName, reason);
    }
}

