/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.common.IItemParticleProvider;
import moe.plushie.armourers_workshop.api.common.IItemSoundProvider;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class UpdateBlockColorPacket
extends CustomPacket {
    final Hand hand;
    final GlobalPos clickedPos;
    final BlockRayTraceResult traceResult;
    final CubePaintingEvent paintingEvent;

    public UpdateBlockColorPacket(IFriendlyByteBuf buffer) {
        this.hand = buffer.readEnum(Hand.class);
        this.clickedPos = buffer.readGlobalPos();
        this.traceResult = buffer.readBlockHitResult();
        this.paintingEvent = new CubePaintingEvent(buffer);
    }

    public UpdateBlockColorPacket(ItemUseContext context, CubePaintingEvent paintingEvent) {
        this.hand = context.func_221531_n();
        this.clickedPos = GlobalPos.func_239648_a_((RegistryKey)context.func_195991_k().func_234923_W_(), (BlockPos)context.func_195995_a());
        this.traceResult = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
        this.paintingEvent = paintingEvent;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum<?>)this.hand);
        buffer.writeGlobalPos(this.clickedPos);
        buffer.writeBlockHitResult(this.traceResult);
        this.paintingEvent.encode(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        ServerWorld level = player.field_71133_b.func_71218_a(this.clickedPos.func_239646_a_());
        if (level == null) {
            return;
        }
        try {
            ItemStack itemStack = player.func_184586_b(this.hand);
            ItemUseContext context = new ItemUseContext((World)level, (PlayerEntity)player, this.hand, itemStack, this.traceResult);
            CubeChangesCollector collector = new CubeChangesCollector((World)level);
            this.paintingEvent.apply(collector, context);
            collector.submit(itemStack.func_200301_q(), (PlayerEntity)player);
            this.applyUseEffects(itemStack, context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BlockPos by(IBlockPaintable target) {
        if (target instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)target;
            return blockEntity.func_174877_v();
        }
        return null;
    }

    private void applyUseEffects(ItemStack itemStack, ItemUseContext context) {
        Object provider;
        Item item = itemStack.func_77973_b();
        if (item instanceof IItemSoundProvider) {
            provider = (IItemSoundProvider)item;
            provider.playSound(context);
        }
        if (item instanceof IItemParticleProvider) {
            provider = (IItemParticleProvider)item;
            provider.playParticle(context);
        }
    }
}

