/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.ColorMixerBlockEntity;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateColorMixerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final GenericValue<ColorMixerBlockEntity, ?> fieldValue;

    public UpdateColorMixerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.fieldValue = Field.TYPE.read(buffer);
    }

    public UpdateColorMixerPacket(ColorMixerBlockEntity entity, GenericValue<ColorMixerBlockEntity, ?> fieldValue) {
        this.pos = entity.func_174877_v();
        this.fieldValue = fieldValue;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.fieldValue.write(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        TileEntity entity = player.func_71121_q().func_175625_s(this.pos);
        if (entity instanceof ColorMixerBlockEntity) {
            ColorMixerBlockEntity blockEntity = (ColorMixerBlockEntity)entity;
            this.fieldValue.apply(blockEntity);
        }
    }

    public static final class Field<T>
    extends GenericProperty<ColorMixerBlockEntity, T> {
        private static final GenericProperties<ColorMixerBlockEntity> TYPE = GenericProperties.of(ColorMixerBlockEntity.class, UpdateColorMixerPacket::new);
        public static final Field<SkinPaintColor> COLOR = Field.create(ColorMixerBlockEntity::color, ColorMixerBlockEntity::setColor, DataSerializers.PAINT_COLOR);

        private static <T> Field<T> create(Function<ColorMixerBlockEntity, T> supplier, BiConsumer<ColorMixerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
        }
    }
}

