/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;

public class CubeReplacingEvent {
    public final ItemStack source;
    public final Block sourceBlock;
    public final BlockPaintColor sourceBlockColor;
    public final ItemStack destination;
    public final Block destinationBlock;
    public final BlockPaintColor destinationBlockColor;
    public final boolean isEmptySource;
    public final boolean isEmptyDestination;
    public final boolean isChangedBlock;
    public boolean keepColor = true;
    public boolean keepPaintType = true;
    public int changes = 0;
    public int blockChanges = 0;
    public int blockColorChanges = 0;

    public CubeReplacingEvent(ItemStack source, ItemStack destination) {
        this.source = source;
        this.sourceBlock = this.getBlock(source);
        this.sourceBlockColor = this.getBlockColor(source);
        this.destination = destination;
        this.destinationBlock = this.getBlock(destination);
        this.destinationBlockColor = this.getBlockColor(destination);
        this.isEmptySource = this.sourceBlock == null && this.sourceBlockColor == null;
        this.isEmptyDestination = this.destinationBlock == null && this.destinationBlockColor == null;
        this.isChangedBlock = this.isChangedBlock();
    }

    public boolean accept(CubeWrapper cube) {
        if (!cube.is(IBlockPaintable.class)) {
            return false;
        }
        if (this.source.func_190926_b()) {
            return true;
        }
        if (this.sourceBlock != null && !cube.is(this.sourceBlock)) {
            return false;
        }
        if (this.sourceBlockColor != null) {
            int diff = 0;
            for (OpenDirection dir : OpenDirection.values()) {
                SkinPaintColor t;
                SkinPaintColor s = this.sourceBlockColor.getOrDefault(dir, SkinPaintColor.WHITE);
                if (Objects.equals(s, t = cube.getColor(dir))) continue;
                ++diff;
            }
            if (this.isChangedBlock) {
                return diff < 1;
            }
            return diff < 6;
        }
        return true;
    }

    public void apply(CubeWrapper cube) {
        if (!cube.is(IBlockPaintable.class)) {
            return;
        }
        int oldBlockChanges = this.blockChanges;
        int oldBlockColorChanges = this.blockColorChanges;
        if (!this.destination.func_190926_b() && this.destinationBlockColor != null) {
            this.applyColor(cube);
        }
        if (this.isChangedBlock) {
            this.applyBlock(cube);
        }
        if (oldBlockChanges != this.blockChanges || oldBlockColorChanges != this.blockColorChanges) {
            ++this.changes;
        }
    }

    private void applyColor(CubeWrapper cube) {
        if (this.keepColor && this.keepPaintType) {
            return;
        }
        HashMap<OpenDirection, SkinPaintColor> newColors = new HashMap<OpenDirection, SkinPaintColor>();
        for (OpenDirection dir : OpenDirection.values()) {
            SkinPaintColor sourceColor;
            SkinPaintColor targetColor = cube.getColor(dir);
            if (this.sourceBlockColor != null && !Objects.equals(sourceColor = this.sourceBlockColor.getOrDefault(dir, SkinPaintColor.WHITE), targetColor)) {
                newColors.put(dir, targetColor);
                continue;
            }
            SkinPaintColor newColor = this.destinationBlockColor.getOrDefault(dir, SkinPaintColor.WHITE);
            int color = newColor.argb();
            if (this.keepColor) {
                color = targetColor.argb();
            }
            SkinPaintType paintType = newColor.paintType();
            if (this.keepPaintType) {
                paintType = targetColor.paintType();
            }
            newColor = SkinPaintColor.of(color, paintType);
            newColors.put(dir, newColor);
        }
        cube.setColors(newColors);
        ++this.blockColorChanges;
    }

    private void applyBlock(CubeWrapper cube) {
        if (!cube.is(SkinCubeBlock.class)) {
            return;
        }
        CompoundNBT newNBT = null;
        BlockState oldState = cube.blockState();
        BlockState newState = Blocks.field_150350_a.func_176223_P();
        if (this.destinationBlock != null) {
            newNBT = cube.blockTag();
            newState = this.destinationBlock.func_176223_P();
            for (Property property : oldState.func_235904_r_()) {
                newState = this.applyBlockState(newState, oldState, property);
            }
        }
        cube.setBlockStateAndTag(newState, newNBT);
        ++this.blockChanges;
    }

    private <T extends Comparable<T>> BlockState applyBlockState(BlockState newState, BlockState oldState, Property<T> property) {
        if (newState.func_235901_b_(property)) {
            return (BlockState)newState.func_206870_a(property, oldState.func_177229_b(property));
        }
        return newState;
    }

    private Block getBlock(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof SkinCubeItem) {
            SkinCubeItem cubeItem = (SkinCubeItem)item;
            return cubeItem.func_179223_d();
        }
        return null;
    }

    private BlockPaintColor getBlockColor(ItemStack itemStack) {
        IItemPaintable provider;
        SkinPaintColor paintColor;
        Item item = itemStack.func_77973_b();
        if (item instanceof SkinCubeItem) {
            SkinCubeItem cubeItem = (SkinCubeItem)item;
            return cubeItem.getItemColors(itemStack);
        }
        if (item instanceof IItemPaintable && (paintColor = (provider = (IItemPaintable)item).getItemColor(itemStack)) != null) {
            return new BlockPaintColor(paintColor);
        }
        return null;
    }

    private boolean isChangedBlock() {
        if (this.source.func_190926_b() && this.destinationBlock != null) {
            return true;
        }
        if (this.destination.func_190926_b() && this.sourceBlock != null) {
            return true;
        }
        return this.destinationBlock != null && !this.destinationBlock.equals(this.sourceBlock);
    }
}

