/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.time.Duration;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSourceImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexConsumer;
import moe.plushie.armourers_workshop.core.data.cache.CacheQueue;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public class AbstractBufferSource
implements IBufferSource {
    private static final AbstractBufferSource DEFAULT = AbstractBufferSource.create(AbstractBufferSourceImpl::bufferSource);
    private static final AbstractBufferSource OUTLINE = AbstractBufferSource.create(AbstractBufferSourceImpl::outlineBufferSource);
    private static final AbstractBufferSource TESSELATOR = AbstractBufferSource.create(80000);
    private static final CacheQueue<Object, AbstractBufferSource> CACHED_BUFFER_SOURCES = new CacheQueue(Duration.ofSeconds(30L));
    private static final CacheQueue<IVertexBuilder, IVertexConsumer> CACHED_BUFFER_BUILDERS = new CacheQueue(Duration.ofSeconds(30L));
    private final Supplier<IRenderTypeBuffer> bufferSourceProvider;

    private AbstractBufferSource(Supplier<IRenderTypeBuffer> bufferSourceProvider) {
        this.bufferSourceProvider = bufferSourceProvider;
    }

    public static AbstractBufferSource buffer() {
        return DEFAULT;
    }

    public static AbstractBufferSource outline() {
        return OUTLINE;
    }

    public static AbstractBufferSource tesselator() {
        return TESSELATOR;
    }

    public static AbstractBufferSource create(int size) {
        return AbstractBufferSource.create(AbstractBufferSourceImpl.immediateSource(size));
    }

    public static AbstractBufferSource create(IRenderTypeBuffer bufferSource) {
        return AbstractBufferSource.create(() -> bufferSource);
    }

    public static AbstractBufferSource create(Supplier<IRenderTypeBuffer> bufferSourceProvider) {
        return new AbstractBufferSource(bufferSourceProvider);
    }

    public static AbstractBufferSource wrap(IRenderTypeBuffer bufferSource) {
        AbstractBufferSource bufferSource1 = CACHED_BUFFER_SOURCES.get(bufferSource);
        if (bufferSource1 == null) {
            bufferSource1 = AbstractBufferSource.create(bufferSource);
            CACHED_BUFFER_SOURCES.put(bufferSource, bufferSource1);
        }
        return bufferSource1;
    }

    public static IRenderTypeBuffer unwrap(IBufferSource bufferSource) {
        return ((AbstractBufferSource)bufferSource).bufferSource();
    }

    @Override
    public IVertexConsumer getBuffer(IRenderType renderType) {
        IVertexBuilder builder = this.bufferSource().getBuffer((RenderType)renderType.get());
        return CACHED_BUFFER_BUILDERS.computeIfAbsent(builder, AbstractVertexConsumer::of);
    }

    @Override
    public void endBatch() {
        IRenderTypeBuffer iRenderTypeBuffer = this.bufferSource();
        if (iRenderTypeBuffer instanceof IRenderTypeBuffer.Impl) {
            IRenderTypeBuffer.Impl bufferSource1 = (IRenderTypeBuffer.Impl)iRenderTypeBuffer;
            bufferSource1.func_228461_a_();
        }
    }

    public IRenderTypeBuffer bufferSource() {
        return this.bufferSourceProvider.get();
    }
}

