/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IModelViewStack;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;
import org.lwjgl.opengl.GL11;

public class AbstractModelViewStackImpl
implements IModelViewStack {
    private final Proxy entry = new Proxy();

    @Override
    public void pushMatrix() {
        GL11.glPushMatrix();
    }

    @Override
    public void popMatrix() {
        GL11.glPopMatrix();
    }

    public void apply() {
    }

    @Override
    public IMatrix4f last() {
        return this.entry;
    }

    public static class Proxy
    implements IMatrix4f {
        private final FloatBuffer buffer = MatrixUtils.createFloatBuffer(16);

        @Override
        public void set(IMatrix4f matrix) {
            this.setIdentity();
            this.multiply(matrix);
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.setIdentity();
            this.multiply(buffer);
        }

        @Override
        public void store(FloatBuffer buffer) {
            GL11.glGetFloatv((int)2982, (FloatBuffer)buffer);
        }

        @Override
        public void translate(float x, float y, float z) {
            GL11.glTranslatef((float)x, (float)y, (float)z);
        }

        @Override
        public void rotate(IQuaternionf quaternion) {
            GL11.glRotatef((float)quaternion.x(), (float)quaternion.y(), (float)quaternion.z(), (float)quaternion.w());
        }

        @Override
        public void scale(float x, float y, float z) {
            GL11.glScalef((float)x, (float)y, (float)z);
        }

        @Override
        public void multiply(IMatrix4f matrix) {
            matrix.store(this.buffer);
            this.buffer.rewind();
            this.multiply(this.buffer);
        }

        @Override
        public void multiply(float[] values) {
        }

        @Override
        public void invert() {
        }

        @Override
        public void transpose() {
        }

        public void setIdentity() {
            GL11.glLoadIdentity();
        }

        public void multiply(FloatBuffer buffer) {
            GL11.glMultMatrixf((FloatBuffer)buffer);
        }
    }
}

