/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import java.util.Map;
import moe.plushie.armourers_workshop.api.client.IVertexFormat;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractVertexFormat
implements IVertexFormat {
    private static final Map<Integer, IVertexFormat.Mode> MAPPER = Collections.immutableMap(it -> {
        it.put((Object)6913, (Object)IVertexFormat.Mode.LINES);
        it.put((Object)3, (Object)IVertexFormat.Mode.LINE_STRIP);
        it.put((Object)4, (Object)IVertexFormat.Mode.TRIANGLES);
        it.put((Object)5, (Object)IVertexFormat.Mode.TRIANGLE_STRIP);
        it.put((Object)6, (Object)IVertexFormat.Mode.TRIANGLE_FAN);
        it.put((Object)7, (Object)IVertexFormat.Mode.QUADS);
    });
    private final VertexFormat impl;

    private AbstractVertexFormat(VertexFormat impl) {
        this.impl = impl;
    }

    public static IVertexFormat of(VertexFormat format) {
        return new AbstractVertexFormat(format);
    }

    public static IVertexFormat.Mode of(int mode) {
        return MAPPER.getOrDefault(mode, IVertexFormat.Mode.QUADS);
    }

    @Override
    public void setupBufferState(long offset) {
        this.impl.func_227892_a_(offset);
    }

    @Override
    public void clearBufferState() {
        this.impl.func_227895_d_();
    }

    @Override
    public int vertexSize() {
        return this.impl.func_177338_f();
    }

    @Override
    public VertexFormat get() {
        return this.impl;
    }
}

