/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.init.command.EntitySelectorPredicate;
import moe.plushie.armourers_workshop.init.command.HasSkinArgumentType;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractEntitySelectorParser {
    private static boolean IS_INITIALED = false;
    private final String name;
    private final ITextComponent description;

    protected AbstractEntitySelectorParser(String name, ITextComponent description) {
        this.name = name;
        this.description = description;
    }

    public static void register(Consumer<AbstractEntitySelectorParser> consumer) {
        if (!IS_INITIALED) {
            consumer.accept(new HasSkinParser());
            IS_INITIALED = true;
        }
    }

    public abstract void parse(EntitySelectorParser var1) throws CommandSyntaxException;

    public boolean canUse(EntitySelectorParser parser) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public ITextComponent getDescription() {
        return this.description;
    }

    private static class HasSkinParser
    extends AbstractEntitySelectorParser {
        protected HasSkinParser() {
            super("skin", (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "commands.armourers_workshop.hasskin.description"));
        }

        @Override
        public void parse(EntitySelectorParser parser) throws CommandSyntaxException {
            boolean bl = parser.func_197378_e();
            HasSkinArgumentType type = new HasSkinArgumentType();
            EntitySelectorPredicate predicate = type.parse(parser.func_197398_f());
            parser.func_197401_a(entity -> predicate.test(entity) != bl);
        }
    }
}

