/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractTooltipContext;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHorizontalBlockImpl
extends HorizontalBlock {
    public AbstractHorizontalBlockImpl(AbstractBlock.Properties properties) {
        super(properties);
    }

    public final List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        return this.getDrops(blockState, new LootContextBuilder(builder));
    }

    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        return super.func_220076_a(blockState, ((LootContextBuilder)context).builder);
    }

    public final void func_176208_a(World level, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        this.destroyByPlayer(level, blockPos, blockState, player);
    }

    public BlockState destroyByPlayer(World level, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        super.func_176208_a(level, blockPos, blockState, player);
        return blockState;
    }

    public ItemStack getCloneItemStack(IWorldReader blockGetter, BlockPos blockPos, BlockState blockState) {
        return super.func_185473_a((IBlockReader)blockGetter, blockPos, blockState);
    }

    public final ItemStack func_185473_a(IBlockReader blockGetter, BlockPos blockPos, BlockState blockState) {
        return this.getCloneItemStack((IWorldReader)blockGetter, blockPos, blockState);
    }

    protected ActionResultType useWithoutItem(BlockState blockState, World level, BlockPos blockPos, PlayerEntity player, BlockRayTraceResult blockHitResult) {
        Hand interactionHand = Hand.MAIN_HAND;
        if (blockState.func_177230_c() != this) {
            return blockState.func_177230_c().func_225533_a_(blockState, level, blockPos, player, interactionHand, blockHitResult.func_237485_a_(blockPos));
        }
        return super.func_225533_a_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public final ActionResultType func_225533_a_(BlockState blockState, World level, BlockPos blockPos, PlayerEntity player, Hand interactionHand, BlockRayTraceResult blockHitResult) {
        return this.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    public void appendHoverText(ItemStack itemStack, List<ITextComponent> tooltips, ITooltipContext context) {
        AbstractTooltipContext context1 = (AbstractTooltipContext)Objects.unsafeCast(context);
        super.func_190948_a(itemStack, (IBlockReader)context1.context, tooltips, context1.flag);
    }

    public final void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockGetter, List<ITextComponent> tooltips, ITooltipFlag tooltipFlag) {
        this.appendHoverText(itemStack, tooltips, new AbstractTooltipContext<IBlockReader>(blockGetter, tooltipFlag));
    }

    public static class LootContextBuilder
    implements ILootContext {
        private static final Map<ILootContextParam<?>, LootParameter<?>> KEYS = Collections.immutableMap(it -> {
            it.put(ILootContextParam.THIS_ENTITY, (Object)LootParameters.field_216281_a);
            it.put(ILootContextParam.LAST_DAMAGE_PLAYER, (Object)LootParameters.field_216282_b);
            it.put(ILootContextParam.DAMAGE_SOURCE, (Object)LootParameters.field_216283_c);
            it.put(ILootContextParam.ATTACKING_ENTITY, (Object)LootParameters.field_216284_d);
            it.put(ILootContextParam.DIRECT_ATTACKING_ENTITY, (Object)LootParameters.field_216285_e);
            it.put(ILootContextParam.ORIGIN, (Object)LootParameters.field_237457_g_);
            it.put(ILootContextParam.BLOCK_STATE, (Object)LootParameters.field_216287_g);
            it.put(ILootContextParam.BLOCK_ENTITY, (Object)LootParameters.field_216288_h);
            it.put(ILootContextParam.TOOL, (Object)LootParameters.field_216289_i);
            it.put(ILootContextParam.EXPLOSION_RADIUS, (Object)LootParameters.field_216290_j);
        });
        private final LootContext.Builder builder;

        public LootContextBuilder(LootContext.Builder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T getParameter(ILootContextParam<T> param) {
            Object value = this.builder.func_216024_a(KEYS.get(param));
            return param.valueType().cast(this.convert(value));
        }

        @Override
        @Nullable
        public <T> T getOptionalParameter(ILootContextParam<T> param) {
            Object value = this.builder.func_216019_b(KEYS.get(param));
            if (value != null) {
                return param.valueType().cast(this.convert(value));
            }
            return null;
        }

        private Object convert(Object value) {
            Vector3d pos = Objects.safeCast(value, Vector3d.class);
            if (pos != null) {
                return new OpenVector3f(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
            return value;
        }
    }
}

