/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunctionType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.ILootCondition;

public class AbstractLootItemFunctionType<T extends ILootFunction>
implements ILootFunctionType<T> {
    private final LootFunctionType type;

    public AbstractLootItemFunctionType(LootFunctionType type) {
        this.type = type;
    }

    public LootFunctionType getType() {
        return this.type;
    }

    public static <T extends ILootFunction> AbstractLootItemFunctionType<T> conditional(MapCodec<T> codec) {
        LootFunctionType[] type = new LootFunctionType[]{null};
        Supplier<LootFunctionType> getter = () -> type[0];
        type[0] = new LootFunctionType(new ConditionalFunction.Factory(getter, codec.codec()));
        return new AbstractLootItemFunctionType<T>(type[0]);
    }

    public static class ConditionalFunction<T extends ILootFunction>
    extends LootFunction {
        private final T value;
        private final Supplier<LootFunctionType> type;

        protected ConditionalFunction(T value, ILootCondition[] args, Supplier<LootFunctionType> type) {
            super(args);
            this.type = type;
            this.value = value;
        }

        protected ItemStack func_215859_a(ItemStack arg, LootContext arg2) {
            return this.value.apply(arg, arg2);
        }

        public void func_225580_a_(ValidationTracker arg) {
            this.value.func_225580_a_(arg);
        }

        public Set<LootParameter<?>> func_215855_a() {
            return this.value.func_215855_a();
        }

        public LootFunctionType func_230425_b_() {
            return this.type.get();
        }

        public static class Factory<T extends ILootFunction>
        extends LootFunction.Serializer<ConditionalFunction<T>> {
            private final Supplier<LootFunctionType> type;
            private final Codec<T> codec;

            public Factory(Supplier<LootFunctionType> type, Codec<T> codec) {
                this.type = type;
                this.codec = codec;
            }

            public void serialize(JsonObject object, ConditionalFunction<T> arg, JsonSerializationContext context) {
                super.func_230424_a_(object, arg, context);
                this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ConditionalFunction)arg).value).get().ifLeft(it -> ((JsonObject)it).entrySet().forEach(entry -> object.add((String)entry.getKey(), (JsonElement)entry.getValue())));
            }

            public ConditionalFunction<T> deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] args) {
                ILootFunction value = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).result().orElse(null);
                return new ConditionalFunction<ILootFunction>(value, args, this.type);
            }
        }
    }
}

