/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractFriendlyByteBufImpl
implements IFriendlyByteBuf {
    protected final PacketBuffer source;

    protected AbstractFriendlyByteBufImpl(PacketBuffer source) {
        this.source = source;
    }

    protected static PacketBuffer cast(ByteBuf buf) {
        PacketBuffer source = Objects.safeCast(buf, PacketBuffer.class);
        if (source == null) {
            source = new PacketBuffer(buf);
        }
        return source;
    }

    protected static PacketBuffer map(ByteBuf buf, Function<ByteBuf, ByteBuf> transform) {
        return new PacketBuffer(transform.apply(buf));
    }

    @Override
    public GlobalPos readGlobalPos() {
        try {
            return (GlobalPos)this.source.func_240628_a_(GlobalPos.field_239645_a_);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void writeGlobalPos(GlobalPos value) {
        try {
            this.source.func_240629_a_(GlobalPos.field_239645_a_, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ItemStack readItem() {
        return this.source.func_150791_c();
    }

    @Override
    public void writeItem(ItemStack value) {
        this.source.func_150788_a(value);
    }

    @Override
    public ITextComponent readComponent() {
        return this.source.func_179258_d();
    }

    @Override
    public void writeComponent(ITextComponent component) {
        this.source.func_179256_a(component);
    }

    @Override
    public <T> T readNbtWithCodec(IDataCodec<T> codec) {
        DataResult dataResult = codec.codec().parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.readNbt());
        return (T)dataResult.getOrThrow(false, string -> {
            throw new DecoderException("Failed to decode nbt: " + string);
        });
    }

    @Override
    public <T> void writeNbtWithCodec(IDataCodec<T> codec, T value) {
        DataResult dataResult = codec.codec().encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, value);
        this.writeNbt((CompoundNBT)dataResult.getOrThrow(false, string -> {
            throw new EncoderException("Failed to encode: " + string + " " + value);
        }));
    }
}

