/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.data.DataContainerKey;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentTypes;
import net.minecraft.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Extension
public class CustomRiddingProvider {
    private static final DataContainerKey<IndexMap> KEY = DataContainerKey.of("Passengers", IndexMap.class);

    @Nullable
    public static OpenVector3f getCustomRidding(@This Entity entity, int index) {
        SkinAttachmentPose attachmentPos;
        IndexMap container = DataContainer.get(entity, KEY);
        if (container == null) {
            return null;
        }
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && (attachmentPos = renderData.getAttachmentPose(SkinAttachmentTypes.RIDING, index)) == null) {
            return null;
        }
        OpenVector3f value = (OpenVector3f)container.get(index);
        if (value != null) {
            return value;
        }
        return (OpenVector3f)container.get(-1);
    }

    public static void setCustomRidding(@This Entity entity, int index, @Nullable OpenVector3f position) {
        IndexMap container = DataContainer.get(entity, KEY);
        if (container == null) {
            container = new IndexMap();
            DataContainer.set(entity, KEY, container);
        }
        container.put(index, position);
    }

    private static class IndexMap
    extends Int2ObjectOpenHashMap<OpenVector3f> {
        private IndexMap() {
        }
    }
}

