/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public interface AbstractForgeBlock
extends IForgeBlock {
    public boolean isBed(BlockState var1, IBlockReader var2, BlockPos var3, LivingEntity var4);

    public boolean isLadder(BlockState var1, IWorldReader var2, BlockPos var3, LivingEntity var4);

    default public boolean isBed(BlockState state, IBlockReader level, BlockPos pos, @Nullable Entity entity) {
        LivingEntity livingEntity = Objects.safeCast(entity, LivingEntity.class);
        return this.isBed(state, level, pos, livingEntity);
    }

    default public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        IBlockHandler handler = (IBlockHandler)Objects.unsafeCast(this);
        ActionResultType result = handler.attackBlock(world, pos, state, Direction.NORTH, player, Hand.MAIN_HAND);
        if (result == ActionResultType.PASS) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (result == ActionResultType.SUCCESS) {
            Block block = (Block)Objects.unsafeCast(this);
            block.func_176208_a(world, pos, state, player);
        }
        return result.func_226246_a_();
    }
}

