/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.registry.IItemBuilder;
import moe.plushie.armourers_workshop.compatibility.client.AbstractItemStackRendererProvider;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import net.minecraft.item.Item;

public abstract class AbstractForgeItemBuilder<T extends Item>
implements IItemBuilder<T> {
    protected Item.Properties properties = new Item.Properties();
    protected IRegistryHolder<IItemGroup> group;
    protected final Function<Item.Properties, T> supplier;

    public AbstractForgeItemBuilder(Function<Item.Properties, T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public IItemBuilder<T> bind(Supplier<AbstractItemStackRendererProvider> provider) {
        this.properties = this.properties.setISTER(() -> ((AbstractItemStackRendererProvider)provider.get())::create);
        return this;
    }

    @Override
    public IRegistryHolder<T> build(String name) {
        return AbstractForgeRegistries.ITEMS.register(name, () -> {
            Item value = (Item)this.supplier.apply(this.properties);
            if (this.group != null) {
                ((IItemGroup)this.group.get()).add(() -> value);
            }
            return value;
        });
    }
}

