/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.api.common.IMenuProvider;
import moe.plushie.armourers_workshop.api.common.IMenuSerializer;
import moe.plushie.armourers_workshop.compatibility.core.AbstractMenuType;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class AbstractForgeMenuType<C extends Container>
extends AbstractMenuType<C> {
    private final ContainerType<C> type = IForgeContainerType.create(this::createMenu);
    private final IMenuProvider<C, Object> factory;
    private final IMenuSerializer<Object> serializer;

    public <T> AbstractForgeMenuType(IMenuProvider<C, T> factory, IMenuSerializer<T> serializer) {
        this.factory = (IMenuProvider)Objects.unsafeCast(factory);
        this.serializer = (IMenuSerializer)Objects.unsafeCast(serializer);
    }

    public static <C extends Container, T> AbstractForgeMenuType<C> create(IMenuProvider<C, T> factory, IMenuSerializer<T> serializer) {
        return new AbstractForgeMenuType<C>(factory, serializer);
    }

    protected C createMenu(int containerId, PlayerInventory inventory, PacketBuffer buf) {
        Object value = this.serializer.read(AbstractFriendlyByteBuf.wrap((ByteBuf)buf), inventory.field_70458_d);
        return (C)((Container)this.factory.createMenu(this.type, containerId, inventory, value));
    }

    @Override
    protected <T> ActionResultType openMenu(ServerPlayerEntity player, final ITextComponent title, final T value) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            @Nullable
            public Container createMenu(int containerId, PlayerInventory inventory, PlayerEntity player) {
                return (Container)AbstractForgeMenuType.this.factory.createMenu(AbstractForgeMenuType.this.type, containerId, inventory, value);
            }

            public ITextComponent func_145748_c_() {
                return title;
            }
        }, buf -> this.serializer.write(AbstractFriendlyByteBuf.wrap((ByteBuf)buf), (PlayerEntity)player, value));
        return ActionResultType.SUCCESS;
    }

    public ContainerType<C> getType() {
        return this.type;
    }
}

