/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge.mixin.dynamiclight;

import moe.plushie.armourers_workshop.core.client.other.SkinLightSource;
import moe.plushie.armourers_workshop.init.client.ClientDynamicLightHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.thinkingstudio.ryoamiclights.api.DynamicLightHandler;
import org.thinkingstudio.ryoamiclights.api.DynamicLightHandlers;
import org.thinkingstudio.ryoamiclights.api.item.ItemLightSources;

public class ForgeRyoamicLightsMixin {

    @Pseudo
    @Mixin(value={DynamicLightHandlers.class})
    public static class BlockEntityLightHandler {
        @Inject(method={"getDynamicLightHandler(Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lorg/thinkingstudio/ryoamiclights/api/DynamicLightHandler;"}, at={@At(value="RETURN")}, cancellable=true, remap=false, require=0)
        private static <T extends TileEntity> void aw2$getDynamicLightHandler(TileEntityType<T> type, CallbackInfoReturnable<DynamicLightHandler<T>> cir) {
            final DynamicLightHandler oldValue = (DynamicLightHandler)cir.getReturnValue();
            cir.setReturnValue((Object)new DynamicLightHandler<T>(){

                public int getLuminance(T entity) {
                    SkinLightSource lightSource;
                    int luminance = 0;
                    if (oldValue != null) {
                        luminance = oldValue.getLuminance(entity);
                    }
                    if ((lightSource = ClientDynamicLightHandler.getLightSource(entity)) != null) {
                        return lightSource.get(luminance);
                    }
                    return luminance;
                }

                public boolean isWaterSensitive(T entity) {
                    if (oldValue != null) {
                        return oldValue.isWaterSensitive(entity);
                    }
                    return false;
                }
            });
        }
    }

    @Pseudo
    @Mixin(value={DynamicLightHandlers.class})
    public static class EntityLightHandler {
        @Inject(method={"getDynamicLightHandler(Lnet/minecraft/world/entity/EntityType;)Lorg/thinkingstudio/ryoamiclights/api/DynamicLightHandler;"}, at={@At(value="RETURN")}, cancellable=true, remap=false, require=0)
        private static <T extends Entity> void aw2$getDynamicLightHandler(EntityType<T> type, CallbackInfoReturnable<DynamicLightHandler<T>> cir) {
            final DynamicLightHandler oldValue = (DynamicLightHandler)cir.getReturnValue();
            cir.setReturnValue((Object)new DynamicLightHandler<T>(){

                public int getLuminance(T entity) {
                    SkinLightSource lightSource;
                    int luminance = 0;
                    if (oldValue != null) {
                        luminance = oldValue.getLuminance(entity);
                    }
                    if ((lightSource = ClientDynamicLightHandler.getLightSource(entity)) != null) {
                        return lightSource.get(luminance);
                    }
                    return luminance;
                }

                public boolean isWaterSensitive(T entity) {
                    if (oldValue != null) {
                        return oldValue.isWaterSensitive(entity);
                    }
                    return false;
                }
            });
        }

        static {
            ClientDynamicLightHandler.init();
        }
    }

    @Pseudo
    @Mixin(value={ItemLightSources.class})
    public static class ItemLightHandler {
        @Inject(method={"getLuminance"}, at={@At(value="RETURN")}, cancellable=true, remap=false, require=0)
        private static void aw2$getLuminance(ItemStack itemStack, boolean submergedInWater, CallbackInfoReturnable<Integer> cir) {
            SkinLightSource lightSource = ClientDynamicLightHandler.getLightSource(itemStack, submergedInWater);
            if (lightSource != null) {
                cir.setReturnValue((Object)lightSource.get((Integer)cir.getReturnValue()));
            }
        }
    }
}

