/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.armature.JointModifier;
import moe.plushie.armourers_workshop.core.armature.core.AfterTransformModifier;
import moe.plushie.armourers_workshop.core.armature.core.DefaultOverriddenArmaturePlugin;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;

public abstract class ArmatureTransformerBuilder {
    protected IResourceLocation parent;
    protected Armature armature;
    protected IODataObject contents;
    protected final IResourceLocation name;
    protected final ArrayList<IResourceLocation> models = new ArrayList();
    protected final ArrayList<IEntityTypeProvider<?>> entities = new ArrayList();
    protected final ArrayList<String> pluginModifiers = new ArrayList();
    protected final HashMap<String, Collection<String>> overrideModifiers = new HashMap();
    protected final HashMap<IJoint, Collection<JointModifier>> jointModifiers = new HashMap();
    protected final HashMap<IJoint, Collection<JointModifier>> transformModifiers = new HashMap();

    public ArmatureTransformerBuilder(IResourceLocation name) {
        this.name = name;
    }

    public void load(IODataObject object) {
        object.get("parent").ifPresent(it -> {
            this.parent = OpenResourceLocation.parse(it.stringValue());
        });
        object.get("target").ifPresent(it -> {
            this.armature = Armatures.byName(OpenResourceLocation.parse(it.stringValue()));
        });
        this.contents = object;
        if (this.armature != null) {
            this._parseContent(object);
        }
    }

    public void resolve(Collection<ArmatureTransformerBuilder> hierarchy) {
        this._parseContentWithParent(this.contents, hierarchy);
        hierarchy.forEach(builder -> {
            this._mergeTo(builder.jointModifiers, this.jointModifiers);
            this._mergeTo(builder.transformModifiers, this.transformModifiers);
            this._mergeTo(builder.overrideModifiers, this.overrideModifiers);
            this._mergeTo(builder.pluginModifiers, this.pluginModifiers);
            if (this.models.isEmpty()) {
                this._mergeTo(builder.models, this.models);
            }
            if (this.entities.isEmpty()) {
                this._mergeTo(builder.entities, this.entities);
            }
        });
    }

    public ArmatureTransformer build(ArmatureTransformerContext context) {
        ArrayList<ArmaturePlugin> plugins = new ArrayList<ArmaturePlugin>();
        HashMap<IJoint, ArrayList> modifiers = new HashMap<IJoint, ArrayList>();
        plugins.add(new DefaultOverriddenArmaturePlugin(this.overrideModifiers, context));
        this.jointModifiers.forEach((joint, modifiers1) -> modifiers.computeIfAbsent((IJoint)joint, k -> new ArrayList()).addAll(modifiers1));
        this.transformModifiers.forEach((joint, modifiers1) -> modifiers.computeIfAbsent((IJoint)joint, k -> new ArrayList()).addAll(modifiers1));
        this.pluginModifiers.forEach(it -> plugins.add(this.buildPlugin((String)it, context)));
        plugins.removeIf(Objects::isNull);
        ArmatureTransformer transformer = new ArmatureTransformer(this.armature, plugins, context);
        modifiers.forEach((joint, values) -> transformer.put((IJoint)joint, this.buildTransform((IJoint)joint, (Collection<JointModifier>)values, context)));
        return transformer;
    }

    protected ArmaturePlugin buildPlugin(String name, ArmatureTransformerContext context) {
        Function<ArmatureTransformerContext, ? extends ArmaturePlugin> builder = ArmatureSerializers.getPlugin(name);
        if (builder != null) {
            return builder.apply(context);
        }
        return null;
    }

    protected IJointTransform buildTransform(IJoint joint, Collection<JointModifier> modifiers, ArmatureTransformerContext context) {
        IModel model = context.entityModel();
        IJointTransform transform = IJointTransform.NONE;
        for (JointModifier modifier : modifiers) {
            transform = modifier.apply(joint, model, transform);
        }
        return transform;
    }

    protected abstract JointModifier buildJointTarget(String var1, IODataObject var2);

    public ArrayList<IResourceLocation> models() {
        return this.models;
    }

    public ArrayList<IEntityTypeProvider<?>> entities() {
        return this.entities;
    }

    public IResourceLocation parent() {
        return this.parent;
    }

    public IResourceLocation name() {
        return this.name;
    }

    private void _parseContentWithParent(IODataObject object, Collection<ArmatureTransformerBuilder> hierarchy) {
        if (this.armature != null || object == null) {
            return;
        }
        for (ArmatureTransformerBuilder builder : hierarchy) {
            if (builder.armature == null) continue;
            this.armature = builder.armature;
            break;
        }
        if (this.armature != null) {
            this._parseContent(object);
        }
    }

    private void _parseContent(IODataObject object) {
        object.get("joint").entrySet().forEach(it -> {
            IJoint joint = this.armature.jointByName((String)it.getKey());
            if (joint != null) {
                this.jointModifiers.put(joint, this._parseModelModifiers((IODataObject)it.getValue()));
            }
        });
        object.get("transform").ifPresent(it -> {
            it.get("translate").entrySet().forEach(it2 -> this._parseTranslateModifiers((String)it2.getKey(), (IODataObject)it2.getValue()));
            it.get("scale").entrySet().forEach(it2 -> this._parseScaleModifiers((String)it2.getKey(), (IODataObject)it2.getValue()));
            it.get("rotate").entrySet().forEach(it2 -> this._parseRotateModifiers((String)it2.getKey(), (IODataObject)it2.getValue()));
        });
        object.get("override").entrySet().forEach(it -> this.overrideModifiers.put((String)it.getKey(), this._parseOverrideModifiers((IODataObject)it.getValue())));
        object.get("plugin").allValues().forEach(it -> this.pluginModifiers.add(it.stringValue()));
        object.get("model").allValues().forEach(it -> this.models.add(ArmatureSerializers.readResourceLocation(it)));
        object.get("entity").allValues().forEach(it -> this.entities.add(ArmatureSerializers.readEntityType(it)));
        this.contents = null;
    }

    private Collection<JointModifier> _parseModelModifiers(IODataObject object) {
        switch (object.type()) {
            case STRING: {
                return this._parseJointTargets(object, null);
            }
            case DICTIONARY: {
                ArrayList<JointModifier> modifiers = new ArrayList<JointModifier>();
                modifiers.addAll(this._parseJointTargets(object, null));
                modifiers.addAll(this._parseTransformModifiers(object));
                modifiers.addAll(this._parseModifiers(object.get("modifier")));
                return modifiers;
            }
        }
        return Collections.emptyList();
    }

    private Collection<JointModifier> _parseJointTargets(IODataObject object, IODataObject parameters) {
        switch (object.type()) {
            case DICTIONARY: {
                return this._parseJointTargets(object.get("target"), object);
            }
            case STRING: {
                String value = object.stringValue();
                if (!value.isEmpty()) {
                    return Collections.singleton(this.buildJointTarget(value, parameters));
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private Collection<JointModifier> _parseModifiers(IODataObject object) {
        switch (object.type()) {
            case ARRAY: {
                ArrayList<JointModifier> modifiers = new ArrayList<JointModifier>();
                object.allValues().forEach(it -> {
                    Supplier<? extends JointModifier> modifier = ArmatureSerializers.getModifier(it.stringValue());
                    if (modifier != null) {
                        modifiers.add(modifier.get());
                    }
                });
                return modifiers;
            }
            case DICTIONARY: {
                ArrayList<JointModifier> modifiers = new ArrayList<JointModifier>();
                object.entrySet().forEach(it -> {
                    Supplier<? extends JointModifier> modifier = ArmatureSerializers.getModifier((String)it.getKey());
                    if (modifier != null) {
                        modifiers.add(modifier.get());
                    }
                });
                return modifiers;
            }
        }
        return Collections.emptyList();
    }

    private Collection<JointModifier> _parseTransformModifiers(IODataObject object) {
        OpenTransform3f transform = ArmatureSerializers.readTransform(object);
        if (transform.isIdentity()) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AfterTransformModifier(transform));
    }

    private Collection<String> _parseOverrideModifiers(IODataObject object) {
        Collection<String> collection;
        switch (object.type()) {
            case STRING: {
                collection = Collections.singleton(object.stringValue());
                break;
            }
            case ARRAY: {
                collection = object.collect(IODataObject::stringValue);
                break;
            }
            default: {
                collection = Collections.emptyList();
            }
        }
        return collection;
    }

    private void _parseTranslateModifiers(String name, IODataObject object) {
        OpenVector3f value = ArmatureSerializers.readVector(object, OpenVector3f.ZERO);
        if (value.equals(OpenVector3f.ZERO)) {
            return;
        }
        OpenTransform3f transform = OpenTransform3f.createTranslateTransform(value);
        this._addTransformModifier(name, new AfterTransformModifier(transform));
    }

    private void _parseRotateModifiers(String name, IODataObject object) {
        OpenVector3f value = ArmatureSerializers.readVector(object, OpenVector3f.ZERO);
        if (value.equals(OpenVector3f.ZERO)) {
            return;
        }
        OpenTransform3f transform = OpenTransform3f.createRotationTransform(value);
        this._addTransformModifier(name, new AfterTransformModifier(transform));
    }

    private void _parseScaleModifiers(String name, IODataObject object) {
        OpenVector3f value = ArmatureSerializers.readVector(object, OpenVector3f.ONE);
        if (value.equals(OpenVector3f.ONE)) {
            return;
        }
        OpenTransform3f transform = OpenTransform3f.createScaleTransform(value);
        this._addTransformModifier(name, new AfterTransformModifier(transform));
    }

    private void _addTransformModifier(String name, JointModifier modifier) {
        Collection<IJoint> joints;
        if (name.equals("") || name.equals("*")) {
            joints = this.armature.allJoints();
        } else {
            IJoint joint = this.armature.jointByName(name);
            if (joint == null) {
                return;
            }
            joints = Collections.singleton(joint);
        }
        for (IJoint joint : joints) {
            this.transformModifiers.computeIfAbsent(joint, k -> new ArrayList()).add(modifier);
        }
    }

    private <K, V> void _mergeTo(Map<K, V> other, Map<K, V> result) {
        other.forEach((key, value) -> {
            if (!result.containsKey(key)) {
                result.put(key, value);
            }
        });
    }

    private <V> void _mergeTo(Collection<V> other, Collection<V> result) {
        result.addAll(other);
    }

    private static interface ArmatureModifierBuilder {
        public JointModifier apply(OpenVector3f var1, OpenVector3f var2, OpenVector3f var3);
    }
}

