/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.Joint;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.JsonSerializer;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import org.jetbrains.annotations.Nullable;

public class Armatures {
    private static final LinkedHashMap<SkinType, Armature> LINKED_ARMATURES = new LinkedHashMap();
    private static final LinkedHashMap<OpenResourceLocation, Armature> NAMED_ARMATURES = new LinkedHashMap();
    public static final Armature HUMANOID = Builder.access$000("humanoid");
    public static final Armature HORSE = Builder.access$000("horse");
    public static final Armature BOAT = Builder.access$000("boat");
    public static final Armature MINECART = Builder.access$000("minecart");
    public static final Armature ANY = Builder.access$000("any");
    public static final Armature HAND = Builder.access$000("hand");

    @Nullable
    public static Armature byName(OpenResourceLocation registryName) {
        return NAMED_ARMATURES.get(registryName);
    }

    public static Armature byType(SkinType skinType) {
        return LINKED_ARMATURES.getOrDefault(skinType, ANY);
    }

    public static void init() {
    }

    private static class Builder {
        private Joint wildcardJoint;
        private final HashSet<SkinType> skinTypes = new HashSet();
        private final LinkedHashMap<String, Joint> namedJoints = new LinkedHashMap();
        private final LinkedHashMap<SkinPartType, Joint> linkedJoints = new LinkedHashMap();
        private final LinkedHashMap<Joint, JointShape> jointShapes = new LinkedHashMap();
        private final LinkedHashMap<Joint, IJointTransform> jointTransforms = new LinkedHashMap();
        private final LinkedHashMap<Joint, String> jointParents = new LinkedHashMap();

        private Builder(String path) {
            ClassLoader loader = this.getClass().getClassLoader();
            try (InputStream inputStream = loader.getResourceAsStream(path);){
                this.load(JsonSerializer.readFromStream(inputStream));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static Armature named(String name) {
            Builder loader = new Builder("data/armourers_workshop/skin/armatures/" + name + ".json");
            return loader.build(name);
        }

        private void load(IODataObject object) {
            object.get("joint").entrySet().forEach(it -> {
                IODataObject value = (IODataObject)it.getValue();
                Joint joint = new Joint((String)it.getKey());
                this.namedJoints.put(joint.name(), joint);
                this.loadType(value.get("id"), SkinPartTypes::byName, partType -> {
                    if (partType != null) {
                        this.linkedJoints.put((SkinPartType)partType, joint);
                    } else {
                        this.wildcardJoint = joint;
                    }
                });
                OpenTransform3f transform = ArmatureSerializers.readTransform(value.get("transform"));
                this.jointShapes.put(joint, ArmatureSerializers.readShape(value.get("cube")));
                this.jointTransforms.put(joint, transform::apply);
                this.jointParents.put(joint, value.get("parent").stringValue());
            });
            this.loadType(object.get("type"), SkinTypes::byName, this.skinTypes::add);
        }

        private <T> void loadType(IODataObject object, Function<String, T> transformer, Consumer<T> consumer) {
            switch (object.type()) {
                case ARRAY: {
                    object.allValues().forEach(it -> this.loadType((IODataObject)it, (Function)transformer, consumer));
                    return;
                }
                case STRING: {
                    String value = object.stringValue();
                    if (value.isEmpty() || value.equals("*")) {
                        consumer.accept(null);
                        return;
                    }
                    T type = transformer.apply(value);
                    if (type != null) {
                        consumer.accept(type);
                    }
                    return;
                }
            }
        }

        private Armature build(String name) {
            this.jointParents.forEach((child, parentName) -> child.setParent(this.namedJoints.get(parentName)));
            Armature armature = new Armature(this.namedJoints, this.jointTransforms, this.linkedJoints, this.wildcardJoint, this.jointShapes);
            OpenResourceLocation registryName = ModConstants.key(name);
            ModLog.debug("Registering Armature '{}'", registryName);
            NAMED_ARMATURES.put(registryName, armature);
            this.skinTypes.forEach(it -> LINKED_ARMATURES.put(it, armature));
            return armature;
        }

        static /* synthetic */ Armature access$000(String x0) {
            return Builder.named(x0);
        }
    }
}

