/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.AnimationModifier;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinOverriddenManager;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class DefaultOverriddenArmaturePlugin
extends ArmaturePlugin {
    private final ArrayList<IModelPart> applying = new ArrayList();
    private final HashMap<SkinProperty<Boolean>, Collection<? extends IModelPart>> overrides = new HashMap();
    private final HashMap<SkinType, Collection<? extends IModelPart>> skinTypeToOverrides = new HashMap();
    private final HashMap<SkinPartType, Collection<? extends IModelPart>> skinPartTypeToOverrides = new HashMap();

    public DefaultOverriddenArmaturePlugin(Map<String, Collection<String>> keys, ArmatureTransformerContext context) {
        context.addEntityModelListener(model -> this.buildOverrides((IModel)model, keys));
    }

    @Override
    public void prepare(Entity entity, ArmaturePlugin.Context context) {
        EntityRenderData renderData = context.renderData();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (renderData.isLimitLimbs()) {
                AnimationModifier.applyLimitLimbs(livingEntity);
            }
        }
    }

    @Override
    public void activate(Entity entity, ArmaturePlugin.Context context) {
        EntityRenderData renderData = context.renderData();
        SkinOverriddenManager<Entity> overriddenManager = renderData.overriddenManager();
        overriddenManager.willRender(entity);
        for (Map.Entry<SkinProperty<Boolean>, Collection<? extends IModelPart>> entry : this.overrides.entrySet()) {
            if (!overriddenManager.contains((ISkinProperty<Boolean>)entry.getKey())) continue;
            this.hidden(entry.getValue());
        }
        for (Map.Entry<Object, Collection<? extends IModelPart>> entry : this.skinTypeToOverrides.entrySet()) {
            if (!this.has((SkinType)entry.getKey(), SkinTypes.UNKNOWN, renderData.usingTypes())) continue;
            this.hidden(entry.getValue());
        }
        for (Map.Entry<Object, Collection<? extends IModelPart>> entry : this.skinPartTypeToOverrides.entrySet()) {
            if (!this.has((SkinPartType)entry.getKey(), SkinPartTypes.UNKNOWN, renderData.usingPartTypes())) continue;
            this.hidden(entry.getValue());
        }
    }

    @Override
    public void deactivate(Entity entity, ArmaturePlugin.Context context) {
        EntityRenderData renderData = context.renderData();
        SkinOverriddenManager<Entity> overriddenManager = renderData.overriddenManager();
        overriddenManager.didRender(entity);
        this.applying.forEach(it -> it.setVisible(true));
        this.applying.clear();
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    private <T> boolean has(T value, T anyValue, Collection<T> list) {
        if (value != anyValue) {
            return list.contains(value);
        }
        return !list.isEmpty();
    }

    private void hidden(Collection<? extends IModelPart> parts) {
        if (ModDebugger.modelOverride) {
            return;
        }
        for (IModelPart iModelPart : parts) {
            if (!iModelPart.isVisible()) continue;
            iModelPart.setVisible(false);
            this.applying.add(iModelPart);
        }
    }

    private void buildOverrides(IModel model, Map<String, Collection<String>> keys) {
        this.overrides.clear();
        keys.forEach((key, names) -> {
            if (key.startsWith("hasType.")) {
                SkinType skinType = SkinTypes.byName(key.replace("hasType.", "armourers:"));
                this.skinTypeToOverrides.put(skinType, this.buildParts((Collection<String>)names, model));
                return;
            }
            if (key.startsWith("hasAnyType")) {
                this.skinTypeToOverrides.put(SkinTypes.UNKNOWN, this.buildParts((Collection<String>)names, model));
                return;
            }
            if (key.startsWith("hasPart.")) {
                SkinPartType skinPartType = SkinPartTypes.byName(key.replace("hasPart.", "armourers:"));
                this.skinPartTypeToOverrides.put(skinPartType, this.buildParts((Collection<String>)names, model));
                return;
            }
            if (key.startsWith("hasAnyPart")) {
                this.skinPartTypeToOverrides.put(SkinPartTypes.UNKNOWN, this.buildParts((Collection<String>)names, model));
                return;
            }
            SkinProperty<Boolean> property = SkinProperty.normal(key, false);
            this.overrides.put(property, this.buildParts((Collection<String>)names, model));
        });
    }

    private Collection<? extends IModelPart> buildParts(Collection<String> names, IModel model) {
        if (names.contains("*")) {
            return model.allParts();
        }
        LinkedHashMap<String, IModelPart> parts = new LinkedHashMap<String, IModelPart>();
        for (String name : names) {
            IModelPart part = model.partByName(name);
            if (part == null) continue;
            parts.put(name, part);
        }
        return parts.values();
    }
}

