/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIView;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinPreviewView;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.menu.DyeTableMenu;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DyeTableWindow
extends MenuWindow<DyeTableMenu> {
    private final SkinPreviewView previewView = new SkinPreviewView(new CGRect(174.0f, 23.0f, 148.0f, 159.0f));

    public DyeTableWindow(DyeTableMenu container, PlayerInventory inventory, NSString title) {
        super(container, inventory, title);
        this.setFrame(new CGRect(0.0f, 0.0f, 330.0f, 190.0f));
        this.inventoryView.setFrame(this.inventoryView.bounds().offset(0.0f, this.bounds().height() - 98.0f));
        this.menuDidChange();
    }

    @Override
    public void init() {
        UIView bg1 = new UIView(new CGRect(0.0f, 0.0f, 256.0f, 190.0f));
        UIView bg2 = new UIView(new CGRect(248.0f, 0.0f, 82.0f, 190.0f));
        bg1.setContents(UIImage.of(ModTextures.DYE_TABLE).build());
        bg2.setContents(UIImage.of(ModTextures.DYE_TABLE).uv(174.0f, 0.0f).build());
        this.insertViewAtIndex(bg2, 0);
        this.insertViewAtIndex(bg1, 0);
        super.init();
        this.addSubview(this.previewView);
    }

    @Override
    public void menuDidChange() {
        SkinDescriptor descriptor = SkinDescriptor.of(((DyeTableMenu)this.menu).outputStack());
        this.previewView.setSkin(descriptor);
        this.loadDyeSlots(descriptor, skin -> {
            if (skin != null) {
                ((DyeTableMenu)this.menu).reload(skin.usedCounter().dyeTypes());
            } else {
                ((DyeTableMenu)this.menu).reload(null);
            }
        });
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        ((DyeTableMenu)this.menu).field_75151_b.stream().filter(slot -> !slot.func_111238_b()).forEach(slot -> context.drawImage(ModTextures.COMMON, slot.field_75223_e - 1, slot.field_75221_f - 1, 18.0f, 18.0f, 202.0f, 0.0f, 256.0f, 256.0f, 200.0f));
    }

    private void loadDyeSlots(SkinDescriptor descriptor, Consumer<BakedSkin> handler) {
        if (descriptor.isEmpty()) {
            handler.accept(null);
        } else {
            SkinBakery.getInstance().loadSkin(TicketManager.TEST.get(descriptor), (skin, except) -> handler.accept((BakedSkin)skin));
        }
    }
}

