/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InputDialog
extends ConfirmDialog
implements UITextFieldDelegate {
    protected final UITextField textField = new UITextField(new CGRect(10.0f, 30.0f, 100.0f, 20.0f));
    private Predicate<String> verifier;
    private boolean isValidText = true;

    public InputDialog() {
        this.textField.setMaxLength(48);
        this.textField.setDelegate(this);
        this.textField.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> self.checkValue(self.value()));
        this.addSubview(this.textField);
        this.setValue("");
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        this.textField.setFrame(new CGRect(10.0f, 30.0f, rect.width - 20.0f, 20.0f));
        this.messageLabel.setFrame(new CGRect(10.0f, 58.0f, rect.width - 20.0f, 20.0f));
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.checkValue(textField.text());
        this.confirmAction(this.confirmButton);
        return true;
    }

    public NSString placeholder() {
        return this.textField.placeholder();
    }

    public void setPlaceholder(NSString placeholder) {
        this.textField.setPlaceholder(placeholder);
    }

    public String value() {
        return this.textField.text();
    }

    public void setValue(String value) {
        this.textField.setText(value);
        this.checkValue(value);
    }

    public Predicate<String> verifier() {
        return this.verifier;
    }

    public void setVerifier(Predicate<String> verifier) {
        this.verifier = verifier;
        this.checkValue(this.value());
    }

    @Override
    public void confirmAction(UIControl sender) {
        if (this.textField.text().isEmpty()) {
            return;
        }
        super.confirmAction(sender);
    }

    private void checkValue(String value) {
        if (this.verifier != null) {
            this.isValidText = this.verifier.test(value);
        }
        this.messageLabel.setHidden(this.isValidText);
        this.confirmButton.setEnabled(this.isValidText);
    }
}

