/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix16;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.animation.AnimationManager;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.SkinLightSource;
import moe.plushie.armourers_workshop.core.client.other.SkinOverriddenManager;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.data.ticket.TicketHolder;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentContainer;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.Nullable;

public class EntitySlotsHandler<T>
implements IAssociatedContainerProvider,
SkinBakery.IBakeListener {
    private final SlotProvider<T> entityProvider;
    private final WardrobeProvider wardrobeProvider;
    private final ArrayList<String> missingSkins = new ArrayList();
    private final HashSet<SkinType> lastSkinTypes = new HashSet();
    private final HashSet<SkinPartType> lastSkinPartTypes = new HashSet();
    private final ArrayList<EntitySlot> allSkins = new ArrayList();
    private final ArrayList<EntitySlot> armorSkins = new ArrayList();
    private final ArrayList<EntitySlot> itemSkins = new ArrayList();
    private final ArrayList<EntitySlot> containerSkins = new ArrayList();
    private final HashMap<SkinDescriptor, BakedSkin> activeSkins = new HashMap();
    private final HashMap<SkinDescriptor, BakedSkin> animatedSkins = new HashMap();
    private final AnimationManager animationManager;
    private final SkinOverriddenManager<T> overriddenManager;
    private final TicketHolder tickets = new TicketHolder("EntitySlotsHandler");
    private final DataContainer dataStorage = new DataContainer();
    private final SkinAttachmentContainer attachmentStorage = new SkinAttachmentContainer();
    private final SkinLightSource lightSource = new SkinLightSource();
    private int version = 0;
    private int lastVersion = Integer.MAX_VALUE;
    private boolean isLimitLimbs = false;
    private boolean isOverrideAttachemntByDefault = false;
    private boolean isListening = false;

    protected EntitySlotsHandler(T entity, SlotProvider<T> entityProvider, WardrobeProvider wardrobeProvider) {
        this.entityProvider = entityProvider;
        this.wardrobeProvider = wardrobeProvider;
        this.animationManager = new AnimationManager(entity);
        this.overriddenManager = new SkinOverriddenManager();
    }

    protected void tick(T source, @Nullable SkinWardrobe wardrobe) {
        this.tickSlots(source, wardrobe);
        this.animationManager.tick(source, TickUtils.animationTicks());
    }

    private void tickSlots(T source, @Nullable SkinWardrobe wardrobe) {
        if (this.wardrobeProvider.tick(wardrobe)) {
            ++this.version;
        }
        if (this.entityProvider.tick(source)) {
            ++this.version;
        }
        if (this.lastVersion != this.version) {
            this.reloadSlots(source, wardrobe);
            this.lastVersion = this.version;
        }
    }

    private void reloadSlots(T source, @Nullable SkinWardrobe wardrobe) {
        this.invalidateAll();
        this.wardrobeProvider.loadDye(wardrobe);
        this.wardrobeProvider.loadWardrobeFlags(wardrobe, this.overriddenManager);
        this.entityProvider.load(source, this::loadSkin);
        this.wardrobeProvider.load(wardrobe, this::loadSkin);
        this.loadSkinInfos();
        this.loadSkinLightInfos(source);
        this.loadArmourEquipments(source);
        this.loadSkinAnimations(source);
        this.loadMissingSkinIfNeeded();
    }

    private void invalidateAll() {
        this.lastVersion = Integer.MAX_VALUE;
        this.isLimitLimbs = false;
        this.lastSkinTypes.clear();
        this.lastSkinPartTypes.clear();
        this.attachmentStorage.clear();
        this.missingSkins.clear();
        this.armorSkins.clear();
        this.itemSkins.clear();
        this.containerSkins.clear();
        this.allSkins.clear();
        this.activeSkins.clear();
        this.animatedSkins.clear();
        this.overriddenManager.clear();
        this.tickets.invalidate();
    }

    private void loadSkin(ItemStack itemStack, float renderPriority, EntitySlot.Type slotType) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.tickets.get(descriptor));
        if (bakedSkin == null) {
            this.missingSkins.add(descriptor.identifier());
            return;
        }
        EntitySlot slot = new EntitySlot(itemStack, descriptor, bakedSkin, this.wardrobeProvider.colorScheme, renderPriority, slotType);
        switch (slotType) {
            case IN_HELD: {
                if (!bakedSkin.type().isTool() && bakedSkin.type() != SkinTypes.ITEM) break;
                this.allSkins.add(slot);
                this.itemSkins.add(slot);
                break;
            }
            case IN_EQUIPMENT: 
            case IN_WARDROBE: {
                if (bakedSkin.type().isTool() || bakedSkin.type() == SkinTypes.ITEM) {
                    this.allSkins.add(slot);
                    this.itemSkins.add(slot);
                    break;
                }
                this.allSkins.add(slot);
                this.armorSkins.add(slot);
                break;
            }
            case IN_CONTAINER: {
                this.allSkins.add(slot);
                this.containerSkins.add(slot);
            }
        }
    }

    private void loadSkinInfos() {
        for (EntitySlot entry : this.allSkins) {
            BakedSkin skin = entry.skin();
            SkinProperties properties = skin.skin().properties();
            this.overriddenManager.merge(properties);
            if (!this.isLimitLimbs) {
                this.isLimitLimbs = properties.get(SkinProperty.LIMIT_LEGS_LIMBS);
            }
            this.lastSkinTypes.add(skin.type());
            for (BakedSkinPart skinPart : skin.parts()) {
                this.lastSkinPartTypes.add(skinPart.type());
            }
            this.activeSkins.put(entry.descriptor(), skin);
        }
    }

    private void loadSkinLightInfos(T source) {
        int luminance = 0;
        for (BakedSkin skin : this.activeSkins.values()) {
            SkinLightSource lightSource1 = skin.renderInfo().lightSource();
            luminance = lightSource1.get(luminance);
        }
        this.lightSource.update(luminance);
    }

    private void loadArmourEquipments(T source) {
        SlotProvider<T> slotProvider = this.entityProvider;
        if (!(slotProvider instanceof EntityProvider)) {
            return;
        }
        EntityProvider entityProvider1 = (EntityProvider)slotProvider;
        boolean isMannequinHand = source instanceof MannequinEntity;
        for (ItemStack itemStack : entityProvider1.armourSlots) {
            for (EntitySlot slot : this.getItemSkins(itemStack, isMannequinHand)) {
                if (slot.skinType() != SkinTypes.ITEM_BACKPACK) continue;
                this.armorSkins.add(slot);
                this.overriddenManager.addProperty(SkinProperty.OVERRIDE_MODEL_BACKPACK);
            }
        }
    }

    private void loadMissingSkinIfNeeded() {
        if (this.missingSkins.isEmpty()) {
            if (this.isListening) {
                SkinBakery.getInstance().removeListener(this);
                this.isListening = false;
            }
        } else if (!this.isListening) {
            SkinBakery.getInstance().addListener(this);
            this.isListening = true;
        }
    }

    private void loadSkinAnimations(T source) {
        this.armorSkins.forEach(this::loadSkinAnimation);
        this.containerSkins.forEach(this::loadSkinAnimation);
        SlotProvider<T> slotProvider = this.entityProvider;
        if (slotProvider instanceof EntityProvider) {
            EntityProvider entityProvider1 = (EntityProvider)slotProvider;
            boolean isMannequinHand = source instanceof MannequinEntity;
            for (ItemStack itemStack : entityProvider1.handSlots) {
                this.getItemSkins(itemStack, isMannequinHand).forEach(this::loadSkinAnimation);
            }
        }
        this.animationManager.load(this.activeSkins);
        this.animationManager.active(this.animatedSkins);
    }

    private void loadSkinAnimation(EntitySlot slot) {
        this.animatedSkins.put(slot.descriptor(), slot.skin());
    }

    @Override
    public void didBake(String identifier, BakedSkin bakedSkin) {
        if (this.missingSkins.contains(identifier)) {
            RenderSystem.safeCall(this::invalidateAll);
        }
    }

    private SkinDescriptor getEmbeddedSkin(ItemStack itemStack, boolean inMannequinHand) {
        if (!inMannequinHand && Fix16.is(itemStack, (Item)ModItems.SKIN.get())) {
            return SkinDescriptor.EMPTY;
        }
        SkinDescriptor target = SkinDescriptor.of(itemStack);
        if (target.type() == SkinTypes.BOAT || target.type() == SkinTypes.ITEM_FISHING || target.type() == SkinTypes.HORSE) {
            return SkinDescriptor.EMPTY;
        }
        return target;
    }

    public List<EntitySlot> getItemSkins(ItemStack itemStack, boolean inMannequinHand) {
        SkinDescriptor target = this.getEmbeddedSkin(itemStack, inMannequinHand);
        if (target.isEmpty()) {
            for (EntitySlot entry : this.itemSkins) {
                if (entry.slotType == EntitySlot.Type.IN_HELD || !entry.shouldRenderInHeld(itemStack)) continue;
                return Collections.singletonList(entry);
            }
        } else {
            for (EntitySlot entry : this.itemSkins) {
                if (!entry.descriptor().equals(target)) continue;
                return Collections.singletonList(entry);
            }
        }
        return Collections.emptyList();
    }

    public List<EntitySlot> itemSkins() {
        return this.itemSkins;
    }

    public List<EntitySlot> armorSkins() {
        return this.armorSkins;
    }

    public List<EntitySlot> allSkins() {
        return this.allSkins;
    }

    public SkinPaintScheme colorScheme() {
        return this.wardrobeProvider.colorScheme;
    }

    public boolean isLimitLimbs() {
        if (!ModConfig.Client.enableSkinLimitLimbs) {
            return false;
        }
        return this.isLimitLimbs;
    }

    public SkinOverriddenManager<T> overriddenManager() {
        return this.overriddenManager;
    }

    public AnimationManager animationManager() {
        return this.animationManager;
    }

    public SkinLightSource lightSource() {
        return this.lightSource;
    }

    public boolean shouldRenderExtra() {
        return this.wardrobeProvider.enableExtraRenderer;
    }

    public Collection<SkinType> usingTypes() {
        return this.lastSkinTypes;
    }

    public Collection<SkinPartType> usingPartTypes() {
        return this.lastSkinPartTypes;
    }

    public void setAttachmentPose(SkinAttachmentType attachmentType, int index, SkinAttachmentPose pose) {
        this.attachmentStorage.put(attachmentType, index, pose);
    }

    public SkinAttachmentPose getAttachmentPose(SkinAttachmentType attachmentType, int index) {
        SkinAttachmentPose attachmentPose = this.attachmentStorage.get(attachmentType, index);
        if (attachmentPose != null) {
            return attachmentPose;
        }
        if (this.isOverrideAttachemntByDefault) {
            return SkinAttachmentPose.EMPTY;
        }
        return null;
    }

    public Int2ObjectMap<SkinAttachmentPose> getAttachmentPoses(SkinAttachmentType attachmentType) {
        return this.attachmentStorage.get(attachmentType);
    }

    public <V> V getAssociatedObject(IAssociatedContainerKey<V> key) {
        return this.dataStorage.getAssociatedObject(key);
    }

    public <V> void setAssociatedObject(IAssociatedContainerKey<V> key, V value) {
        this.dataStorage.setAssociatedObject(key, value);
    }

    protected static abstract class SlotProvider<T> {
        protected List<ItemStack> slots = new ArrayList<ItemStack>();
        protected List<ItemStack> lastSlots = new ArrayList<ItemStack>();

        protected SlotProvider() {
        }

        public boolean tick(T source) {
            List<ItemStack> oldSlots = this.lastSlots;
            List<ItemStack> newSlots = this.slots;
            newSlots.clear();
            this.collect(source, newSlots);
            this.slots = oldSlots;
            this.lastSlots = newSlots;
            return !newSlots.equals(oldSlots);
        }

        protected abstract void load(T var1, SlotConsumer var2);

        protected abstract void collect(T var1, List<ItemStack> var2);
    }

    protected static class WardrobeProvider
    extends SlotProvider<SkinWardrobe> {
        protected final HashMap<SkinPaintType, SkinPaintColor> dyeColors = new HashMap();
        protected final HashMap<SkinPaintType, SkinPaintColor> lastDyeColors = new HashMap();
        protected BitSet wardrobeFlags = new BitSet();
        protected SkinPaintScheme colorScheme = SkinPaintScheme.EMPTY;
        protected EntityProfile profile = null;
        protected boolean enableExtraRenderer = false;

        protected WardrobeProvider() {
        }

        @Override
        public boolean tick(SkinWardrobe wardrobe) {
            if (wardrobe == null) {
                this.profile = null;
                this.enableExtraRenderer = false;
                return false;
            }
            boolean result = super.tick(wardrobe);
            BitSet flags = wardrobe.flags();
            if (!this.wardrobeFlags.equals(flags)) {
                this.wardrobeFlags.clear();
                this.wardrobeFlags.or(flags);
                result = true;
            }
            this.profile = wardrobe.profile();
            return result;
        }

        protected void loadDye(SkinWardrobe wardrobe) {
            if (wardrobe == null || this.profile == null) {
                return;
            }
            this.dyeColors.clear();
            for (SkinPaintType paintType2 : SkinSlotType.getSupportedPaintTypes()) {
                ItemStack itemStack = (ItemStack)this.lastSlots.get(SkinSlotType.getDyeSlotIndex(paintType2));
                SkinPaintColor paintColor2 = (SkinPaintColor)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
                if (paintColor2 == null) continue;
                this.dyeColors.put(paintType2, paintColor2);
            }
            if (!this.lastDyeColors.equals(this.dyeColors)) {
                this.colorScheme = new SkinPaintScheme();
                this.lastDyeColors.clear();
                this.dyeColors.forEach((paintType, paintColor) -> {
                    this.lastDyeColors.put((SkinPaintType)paintType, (SkinPaintColor)paintColor);
                    this.colorScheme.setColor((SkinPaintType)paintType, (SkinPaintColor)paintColor);
                });
            }
        }

        protected void loadWardrobeFlags(SkinWardrobe wardrobe, SkinOverriddenManager overriddenManager) {
            if (wardrobe == null) {
                return;
            }
            for (OpenEquipmentSlot slotType : OpenEquipmentSlot.values()) {
                if (wardrobe.shouldRenderEquipment(slotType)) {
                    overriddenManager.removeEquipment(slotType);
                    continue;
                }
                overriddenManager.addEquipment(slotType);
            }
            this.enableExtraRenderer = wardrobe.shouldRenderExtra();
        }

        @Override
        protected void load(SkinWardrobe wardrobe, SlotConsumer consumer) {
            if (wardrobe == null || this.profile == null) {
                return;
            }
            HashSet<SkinSlotType> usedSlots = new HashSet<SkinSlotType>();
            for (SkinSlotType slotType : this.profile.slots()) {
                if (slotType == SkinSlotType.DYE) {
                    return;
                }
                for (int i = 0; i < slotType.maxSize(); ++i) {
                    ItemStack itemStack = (ItemStack)this.lastSlots.get(slotType.index() + i);
                    SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
                    if (!descriptor.isEmpty()) {
                        usedSlots.add(slotType);
                    }
                    consumer.accept(itemStack, i * 10, EntitySlot.Type.IN_WARDROBE);
                }
            }
            SkinSlotType slotType = SkinSlotType.DEFAULT;
            for (int i = 0; i < slotType.maxSize(); ++i) {
                SkinSlotType realSlotType;
                ItemStack itemStack = (ItemStack)this.lastSlots.get(slotType.index() + i);
                SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
                if (descriptor.isEmpty() || usedSlots.contains((Object)(realSlotType = SkinSlotType.byType(descriptor.type())))) continue;
                consumer.accept(itemStack, i * 10, EntitySlot.Type.IN_WARDROBE);
            }
        }

        @Override
        protected void collect(SkinWardrobe wardrobe, List<ItemStack> collector) {
            IInventory inventory = wardrobe.inventory();
            int size = inventory.func_70302_i_();
            for (int index = 0; index < size; ++index) {
                collector.add(inventory.func_70301_a(index));
            }
        }
    }

    protected static interface SlotConsumer {
        public void accept(ItemStack var1, float var2, EntitySlot.Type var3);
    }

    protected static class EntityProvider
    extends SlotProvider<Entity> {
        protected List<ItemStack> handSlots = new ArrayList<ItemStack>();
        protected List<ItemStack> armourSlots = new ArrayList<ItemStack>();

        protected EntityProvider() {
        }

        @Override
        protected void load(Entity source, SlotConsumer consumer) {
            int i = 0;
            for (ItemStack itemStack : this.armourSlots) {
                consumer.accept(itemStack, 400 + i++, EntitySlot.Type.IN_EQUIPMENT);
            }
            for (ItemStack itemStack : this.handSlots) {
                consumer.accept(itemStack, 400 + i++, EntitySlot.Type.IN_HELD);
            }
        }

        @Override
        protected void collect(Entity entity, List<ItemStack> collector) {
            this.handSlots.clear();
            moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.SlotProvider.getExtendedHandSlots(entity).forEach(itemStack -> {
                this.handSlots.add((ItemStack)itemStack);
                collector.add((ItemStack)itemStack);
            });
            this.armourSlots.clear();
            moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.SlotProvider.getExtendedArmorSlots(entity).forEach(itemStack -> {
                this.armourSlots.add((ItemStack)itemStack);
                collector.add((ItemStack)itemStack);
            });
        }
    }

    protected static class BlockEntityProvider
    extends SlotProvider<TileEntity> {
        protected BlockEntityProvider() {
        }

        @Override
        protected void load(TileEntity source, SlotConsumer consumer) {
            int i = 0;
            for (ItemStack itemStack : this.lastSlots) {
                consumer.accept(itemStack, 400 + i++, EntitySlot.Type.IN_CONTAINER);
            }
        }

        @Override
        protected void collect(TileEntity blockEntity, List<ItemStack> collector) {
            RotableContainerBlockEntity blockEntity1;
            if (blockEntity instanceof SkinnableBlockEntity) {
                blockEntity1 = (SkinnableBlockEntity)blockEntity;
                collector.add(((SkinnableBlockEntity)blockEntity1).getSkin().sharedItemStack());
            }
            if (blockEntity instanceof HologramProjectorBlockEntity) {
                blockEntity1 = (HologramProjectorBlockEntity)blockEntity;
                collector.add(blockEntity1.func_70301_a(0));
            }
        }
    }
}

