/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.EquipmentItemProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SlotDirectAccessor;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinOverriddenManager<T> {
    private static final List<OpenEquipmentSlot> ARMOUR_EQUIPMENT_SLOTS = Collections.immutableList(it -> {
        it.add((Object)OpenEquipmentSlot.HEAD);
        it.add((Object)OpenEquipmentSlot.CHEST);
        it.add((Object)OpenEquipmentSlot.LEGS);
        it.add((Object)OpenEquipmentSlot.FEET);
    });
    private static final List<ISkinProperty<Boolean>> OVERRIDDEN_PROPERTIES = Collections.immutableList(it -> {
        it.add(SkinProperty.OVERRIDE_MODEL_HEAD);
        it.add(SkinProperty.OVERRIDE_MODEL_CHEST);
        it.add(SkinProperty.OVERRIDE_MODEL_LEFT_ARM);
        it.add(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM);
        it.add(SkinProperty.OVERRIDE_MODEL_LEFT_LEG);
        it.add(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG);
        it.add(SkinProperty.OVERRIDE_MODEL_LEFT_FRONT_LEG);
        it.add(SkinProperty.OVERRIDE_MODEL_RIGHT_FRONT_LEG);
        it.add(SkinProperty.OVERRIDE_MODEL_LEFT_HIND_LEG);
        it.add(SkinProperty.OVERRIDE_MODEL_RIGHT_HIND_LEG);
        it.add(SkinProperty.OVERRIDE_MODEL_TAIL);
        it.add(SkinProperty.OVERRIDE_OVERLAY_HAT);
        it.add(SkinProperty.OVERRIDE_OVERLAY_CLOAK);
        it.add(SkinProperty.OVERRIDE_OVERLAY_JACKET);
        it.add(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE);
        it.add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE);
        it.add(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS);
        it.add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS);
        it.add(SkinProperty.OVERRIDE_EQUIPMENT_HELMET);
        it.add(SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE);
        it.add(SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS);
        it.add(SkinProperty.OVERRIDE_EQUIPMENT_BOOTS);
    });
    private static final Map<ISkinProperty<Boolean>, OpenEquipmentSlot> OVERRIDDEN_EQUIPMENT_TO_SLOT = Collections.immutableMap(it -> {
        it.put(SkinProperty.OVERRIDE_EQUIPMENT_HELMET, (Object)OpenEquipmentSlot.HEAD);
        it.put(SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, (Object)OpenEquipmentSlot.CHEST);
        it.put(SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, (Object)OpenEquipmentSlot.LEGS);
        it.put(SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, (Object)OpenEquipmentSlot.FEET);
    });
    private static final Map<ISkinProperty<Boolean>, Collection<ISkinProperty<Boolean>>> OVERRIDDEN_MODEL_TO_OVERLAY = Collections.immutableMap(it -> {
        it.put(SkinProperty.OVERRIDE_MODEL_HEAD, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_HAT));
        it.put(SkinProperty.OVERRIDE_MODEL_CHEST, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_CLOAK));
        it.put(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE));
        it.put(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE));
        it.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS));
        it.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS));
    });
    private final HashSet<ISkinProperty<Boolean>> disabledProperties = new HashSet();
    private final HashSet<ISkinProperty<Boolean>> disabledModelByProperties = new HashSet();
    private final HashSet<OpenEquipmentSlot> disabledEquipmentSlots = new HashSet();
    private final HashSet<OpenEquipmentSlot> disabledEquipmentSlotsByProperties = new HashSet();
    private final HashMap<OpenEquipmentSlot, ItemStack> disabledEquipmentItems = new HashMap();

    public void addEquipment(OpenEquipmentSlot slotType) {
        this.disabledEquipmentSlots.add(slotType);
    }

    public void removeEquipment(OpenEquipmentSlot slotType) {
        this.disabledEquipmentSlots.remove((Object)slotType);
    }

    public void addProperty(ISkinProperty<Boolean> property) {
        Collection<ISkinProperty<Boolean>> overlayProperties;
        this.disabledProperties.add(property);
        OpenEquipmentSlot equipmentSlot = OVERRIDDEN_EQUIPMENT_TO_SLOT.get(property);
        if (equipmentSlot != null) {
            this.disabledEquipmentSlotsByProperties.add(equipmentSlot);
        }
        if ((overlayProperties = OVERRIDDEN_MODEL_TO_OVERLAY.get(property)) != null) {
            this.disabledModelByProperties.add(property);
            this.disabledProperties.addAll(overlayProperties);
        }
    }

    public void merge(ISkinProperties properties) {
        for (ISkinProperty<Boolean> property : OVERRIDDEN_PROPERTIES) {
            if (!properties.get(property).booleanValue()) continue;
            this.addProperty(property);
        }
    }

    public boolean contains(ISkinProperty<Boolean> property) {
        return this.disabledProperties.contains(property);
    }

    public boolean overrideEquipment(OpenEquipmentSlot slotType) {
        return this.disabledEquipmentSlots.contains((Object)slotType) || this.disabledEquipmentSlotsByProperties.contains((Object)slotType);
    }

    public boolean overrideAnyModel() {
        return !this.disabledModelByProperties.isEmpty();
    }

    public boolean overrideHandModel(OpenItemDisplayContext transformType) {
        if (transformType.isLeftHand()) {
            return this.contains(SkinProperty.OVERRIDE_MODEL_LEFT_ARM);
        }
        if (transformType.isRightHand()) {
            return this.contains(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM);
        }
        return false;
    }

    public void clear() {
        this.disabledProperties.clear();
        this.disabledModelByProperties.clear();
        this.disabledEquipmentSlots.clear();
        this.disabledEquipmentSlotsByProperties.clear();
    }

    public void willRender(T source) {
        for (OpenEquipmentSlot equipmentSlot : ARMOUR_EQUIPMENT_SLOTS) {
            if (!this.overrideEquipment(equipmentSlot) || this.disabledEquipmentItems.containsKey((Object)equipmentSlot)) continue;
            ItemStack itemStack = this.setItem(source, equipmentSlot, ItemStack.field_190927_a);
            this.disabledEquipmentItems.put(equipmentSlot, itemStack);
        }
    }

    public void didRender(T source) {
        for (OpenEquipmentSlot slotType : ARMOUR_EQUIPMENT_SLOTS) {
            if (!this.disabledEquipmentItems.containsKey((Object)slotType)) continue;
            ItemStack itemStack = this.disabledEquipmentItems.remove((Object)slotType);
            this.setItem(source, slotType, itemStack);
        }
    }

    private ItemStack setItem(T source, OpenEquipmentSlot slotType, ItemStack itemStack) {
        if (source instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source;
            ItemStack oldItemStack = EquipmentItemProvider.getItemBySlot((LivingEntity)player, slotType);
            SlotDirectAccessor.setItemSlotDirect(player, slotType, itemStack);
            return oldItemStack;
        }
        if (source instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)source;
            ItemStack oldItemStack = EquipmentItemProvider.getItemBySlot(livingEntity, slotType);
            EquipmentItemProvider.setItemSlot(livingEntity, slotType, itemStack);
            return oldItemStack;
        }
        return itemStack;
    }
}

