/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelHolder;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractSkinnableModel;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.core.DefaultLayerArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.client.other.EntityRendererContext;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayBodyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayHeadJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayWingJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.DefaultBabyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.DefaultSkirtJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.FlatWingJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.HorseBodyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.ArrowModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.BoatModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.FishingModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.MinecartModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.TridentModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.VillagerModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.data.DataPackBuilder;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRendererManager {
    public static final ArmatureTransformerManager DEFAULT = new DefaultArmatureTransformerManager();
    public static final ArmatureTransformerManager EPIC_FIGHT = new EpicFlightArmatureTransformerManager();

    public static void init() {
        ProfileLoader.init();
        TransformerLoader.init();
    }

    public static void reload() {
        ProfileLoader.reload();
    }

    private static class ProfileLoader {
        private static final Map<IEntityTypeProvider<?>, EntityProfile> ENTITIES = new LinkedHashMap();
        private static boolean IS_READY = false;

        private ProfileLoader() {
        }

        public static void init() {
            ModEntityProfiles.addListener(ProfileLoader::profileDidChange);
        }

        public static void reload() {
            EntityRendererManager entityRenderManager = EnvironmentManager.getClient().func_175598_ae();
            if (entityRenderManager == null) {
                RenderSystem.recordRenderCall(SkinRendererManager::reload);
                return;
            }
            RenderSystem.recordRenderCall(() -> {
                IS_READY = false;
                ENTITIES.forEach(ProfileLoader::update);
                IS_READY = true;
            });
        }

        public static void update(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
            EntityRenderer renderer;
            EntityType resolvedEntityType = (EntityType)entityType.get();
            if (resolvedEntityType == null) {
                return;
            }
            EntityRendererManager entityRenderManager = EnvironmentManager.getClient().func_175598_ae();
            if (entityRenderManager == null) {
                return;
            }
            if (resolvedEntityType == EntityType.field_200729_aH) {
                for (PlayerRenderer renderer2 : entityRenderManager.field_178636_l.values()) {
                    if (renderer2 == null) continue;
                    EntityRendererContext rendererContext = EntityRendererContext.of(renderer2);
                    rendererContext.setEntityType(resolvedEntityType);
                    rendererContext.setEntityProfile(entityProfile);
                }
            }
            if ((renderer = (EntityRenderer)entityRenderManager.field_78729_o.get(resolvedEntityType)) != null) {
                EntityRendererContext rendererContext = EntityRendererContext.of(renderer);
                rendererContext.setEntityType(resolvedEntityType);
                rendererContext.setEntityProfile(entityProfile);
            }
        }

        public static void profileDidChange(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
            if (entityProfile != null) {
                if (ENTITIES.containsKey(entityType)) {
                    ModLog.debug("Update Entity Renderer '{}'", entityType.registryName());
                } else {
                    ModLog.debug("Attach Entity Renderer '{}'", entityType.registryName());
                }
                ENTITIES.put(entityType, entityProfile);
            } else {
                ModLog.debug("Detach Entity Renderer '{}'", entityType.registryName());
                ENTITIES.remove(entityType);
            }
            if (IS_READY) {
                RenderSystem.safeCall(() -> ProfileLoader.update(entityType, entityProfile));
            }
        }
    }

    private static class TransformerLoader
    extends ArmatureSerializers {
        private TransformerLoader() {
        }

        public static void init() {
            TransformerLoader.registerModifiers();
            TransformerLoader.registerPlugins();
            TransformerLoader.registerRenderers();
            TransformerLoader.registerModels();
            DataPackManager.register(DataPackType.BUNDLED_DATA, "skin/transformers", TransformerLoaderImpl::new, TransformerLoaderImpl::clean, TransformerLoaderImpl::freeze, 0);
        }

        private static void registerModifiers() {
            TransformerLoader.registerModifier("armourers_workshop:modifier/baby_head_apt", DefaultBabyJointModifier::new);
            TransformerLoader.registerModifier("armourers_workshop:modifier/body_to_skirt", DefaultSkirtJointModifier::new);
            TransformerLoader.registerModifier("armourers_workshop:modifier/body_to_flat_wing", FlatWingJointModifier::new);
            TransformerLoader.registerModifier("armourers_workshop:modifier/apply_ally_head", AllayHeadJointModifier::new);
            TransformerLoader.registerModifier("armourers_workshop:modifier/apply_ally_body", AllayBodyJointModifier::new);
            TransformerLoader.registerModifier("armourers_workshop:modifier/apply_ally_wing", AllayWingJointModifier::new);
            TransformerLoader.registerModifier("armourers_workshop:modifier/apply_horse_body", HorseBodyJointModifier::new);
        }

        private static void registerPlugins() {
            TransformerLoader.registerPlugin("armourers_workshop:plugin/hidden_any_layer", DefaultLayerArmaturePlugin::any);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/hidden_villager_layer", DefaultLayerArmaturePlugin::villager);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/hidden_mob_layer", DefaultLayerArmaturePlugin::mob);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/fix_villager_model", VillagerModelArmaturePlugin::new);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/fix_trident_model", TridentModelArmaturePlugin::new);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/fix_arrow_model", ArrowModelArmaturePlugin::new);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/fix_fishing_model", FishingModelArmaturePlugin::new);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/fix_boat_model", BoatModelArmaturePlugin::new);
            TransformerLoader.registerPlugin("armourers_workshop:plugin/fix_minecart_model", MinecartModelArmaturePlugin::new);
        }

        private static void registerRenderers() {
        }

        private static void registerModels() {
            TransformerLoader.registerModel("minecraft:model/slime", AbstractSkinnableModel.SLIME);
            TransformerLoader.registerModel("minecraft:model/ghast", AbstractSkinnableModel.GHAST);
            TransformerLoader.registerModel("minecraft:model/enderman", AbstractSkinnableModel.ENDERMAN);
            TransformerLoader.registerModel("minecraft:model/zombie_villager", AbstractSkinnableModel.ZOMBIE_VILLAGER);
            TransformerLoader.registerModel("minecraft:model/illager", AbstractSkinnableModel.ILLAGER, it -> {
                it.put("head", "root.head");
                it.put("body", "root.body");
                it.put("left_leg", "root.left_leg");
                it.put("right_leg", "root.right_leg");
                it.put("arms", "root.arms");
                it.put("right_arm", "root.right_arm");
                it.put("left_arm", "root.left_arm");
                it.put("hat", "root.head.hat");
                it.put("nose", "root.head.nose");
            });
            TransformerLoader.registerModel("minecraft:model/villager", AbstractSkinnableModel.VILLAGER, it -> {
                it.put("hat", "root.head.hat");
                it.put("hat_rim", "root.head.hat.hat_rim");
                it.put("head", "root.head");
                it.put("nose", "root.head.nose");
                it.put("body", "root.body");
                it.put("right_leg", "root.right_leg");
                it.put("left_leg", "root.left_leg");
                it.put("left_arm", "root.arms");
                it.put("right_arm", "root.arms");
                it.put("jacket", "root.body.jacket");
            });
            TransformerLoader.registerModel("minecraft:model/iron_golem", AbstractSkinnableModel.IRON_GOLEM, it -> {
                it.put("head", "root.head");
                it.put("body", "root.body");
                it.put("right_leg", "root.right_leg");
                it.put("left_leg", "root.left_leg");
                it.put("right_arm", "root.right_arm");
                it.put("left_arm", "root.left_arm");
            });
            TransformerLoader.registerModel("minecraft:model/humanoid", AbstractSkinnableModel.HUMANOID, it -> {
                it.put("head", "headParts[0]");
                it.put("body", "bodyParts[0]");
                it.put("right_arm", "bodyParts[1]");
                it.put("left_arm", "bodyParts[2]");
                it.put("right_leg", "bodyParts[3]");
                it.put("left_leg", "bodyParts[4]");
                it.put("hat", "bodyParts[5]");
            });
            TransformerLoader.registerModel("minecraft:model/player", AbstractSkinnableModel.PLAYER, it -> {
                it.put("left_pants", "bodyParts[6]");
                it.put("right_pants", "bodyParts[7]");
                it.put("left_sleeve", "bodyParts[8]");
                it.put("right_sleeve", "bodyParts[9]");
                it.put("jacket", "bodyParts[10]");
            });
            TransformerLoader.registerModel("minecraft:model/chicken", AbstractSkinnableModel.CHICKEN, it -> {
                it.put("head", "headParts[0]");
                it.put("beak", "headParts[1]");
                it.put("red_thing", "headParts[2]");
                it.put("body", "bodyParts[0]");
                it.put("right_leg", "bodyParts[1]");
                it.put("left_leg", "bodyParts[2]");
                it.put("right_wing", "bodyParts[3]");
                it.put("left_wing", "bodyParts[4]");
            });
            TransformerLoader.registerModel("minecraft:model/creeper", AbstractSkinnableModel.CREEPER, it -> it.put("head", "root.head"));
            TransformerLoader.registerModel("minecraft:model/horse", AbstractSkinnableModel.HORSE, it -> {
                it.put("head", "headParts[0]");
                it.put("body", "bodyParts[0]");
                it.put("right_hind_leg", "bodyParts[1]");
                it.put("left_hind_leg", "bodyParts[2]");
                it.put("right_front_leg", "bodyParts[3]");
                it.put("left_front_leg", "bodyParts[4]");
                it.put("right_front_baby_leg", "bodyParts[5]");
                it.put("left_front_baby_leg", "bodyParts[6]");
                it.put("right_hind_baby_leg", "bodyParts[7]");
                it.put("left_hind_baby_leg", "bodyParts[8]");
                it.put("tail", "bodyParts[0].tail");
            });
            TransformerLoader.registerModel("minecraft:model/boat", AbstractSkinnableModel.BOAT, it -> {
                it.put("bottom", "parts[0]");
                it.put("back", "parts[1]");
                it.put("front", "parts[2]");
                it.put("right", "parts[3]");
                it.put("left", "parts[4]");
                it.put("left_paddle", "parts[5]");
                it.put("right_paddle", "parts[6]");
            });
            TransformerLoader.registerModel("minecraft:model/raft", AbstractSkinnableModel.RAFT, it -> {
                it.put("bottom", "parts[0]");
                it.put("left_paddle", "parts[1]");
                it.put("right_paddle", "parts[2]");
            });
            TransformerLoader.registerModel("minecraft:model/allay", AbstractSkinnableModel.ALLAY, it -> {
                it.put("root", "root");
                it.put("head", "root.head");
                it.put("body", "root.body");
                it.put("right_arm", "root.body.right_arm");
                it.put("left_arm", "root.body.left_arm");
                it.put("right_leg", "root.body.right_wing");
                it.put("left_leg", "root.body.left_wing");
                it.put("right_wing", "root.body.right_wing");
                it.put("left_wing", "root.body.left_wing");
            });
        }

        public static <T extends Model> void registerModel(String registryName, Class<T> clazz) {
            TransformerLoader.registerModel(registryName, clazz, it -> {});
        }

        public static <T extends Model> void registerModel(String registryName, Class<T> clazz, Consumer<Map<String, String>> provider) {
            if (clazz != null) {
                LinkedHashMap<String, String> mapper = new LinkedHashMap<String, String>();
                provider.accept(mapper);
                TransformerLoader.registerClass(registryName, clazz);
                AbstractModelHolder.register(clazz, mapper);
            }
        }
    }

    private static class TransformerLoaderImpl
    implements DataPackBuilder {
        private static final Map<String, ArmatureTransformerManager> MANAGERS = Collections.immutableMap(it -> {
            it.put((Object)"armourers_workshop:armature", (Object)DEFAULT);
            it.put((Object)"epicfight:armature", (Object)EPIC_FIGHT);
        });
        private final IResourceLocation registryName;

        public TransformerLoaderImpl(IResourceLocation location) {
            String path = FileUtils.getRegistryName(location.path(), "skin/transformers/");
            this.registryName = location.withPath(path);
        }

        @Override
        public void append(IODataObject object, IResourceLocation file) {
            String type = object.get("type").stringValue();
            ArmatureTransformerManager manager = MANAGERS.get(type);
            if (manager != null) {
                manager.append(this.registryName, object);
            }
        }

        @Override
        public void build() {
        }

        public static void clean() {
            MANAGERS.values().forEach(ArmatureTransformerManager::clear);
        }

        public static void freeze() {
            MANAGERS.values().forEach(ArmatureTransformerManager::freeze);
        }
    }
}

