/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.item.MannequinItem;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MannequinHitResult
extends BlockRayTraceResult {
    private final float scale;
    private final float rotation;

    public MannequinHitResult(BlockPos pos, Vector3d location, float scale, float rotation) {
        super(location, Direction.UP, pos, false);
        this.scale = scale;
        this.rotation = rotation;
    }

    public static MannequinHitResult test(PlayerEntity player, Vector3d origin, Vector3d target, BlockPos pos) {
        World level = PropertyProvider.getLevel((Entity)player);
        ItemStack itemStack = player.func_184614_ca();
        float scale = MannequinItem.getScale(itemStack);
        float rotation = (float)OpenMath.getAngleDegrees(origin.func_82615_a(), origin.func_82616_c(), target.func_82615_a(), target.func_82616_c()) + 90.0f;
        if (MannequinItem.isSmall(itemStack)) {
            scale *= 0.5f;
        }
        BlockState blockState = level.func_180495_p(pos);
        if (player.func_226563_dT_()) {
            VoxelShape shape = blockState.func_196954_c((IBlockReader)level, pos);
            target = Vector3d.func_237490_a_((Vector3i)pos, (double)shape.func_197758_c(Direction.Axis.Y));
            VoxelShape collisionShape = blockState.func_196952_d((IBlockReader)level, pos);
            if (!Block.func_208061_a((VoxelShape)collisionShape, (Direction)Direction.UP)) {
                BlockRayTraceResult collisionBox;
                Vector3d newLocation = Vector3d.func_237492_c_((Vector3i)pos);
                if (!collisionShape.func_197766_b() && (collisionBox = shape.func_212433_a(target, newLocation, pos)) != null) {
                    newLocation = collisionBox.func_216347_e();
                }
                target = newLocation;
            }
            int l = OpenMath.floori((double)(PropertyProvider.getYRot((Entity)player) * 16.0f / 360.0f) + 0.5) % 16;
            rotation = (float)l * 22.5f + 180.0f;
        }
        return new MannequinHitResult(pos, target, scale, rotation);
    }

    public float scale() {
        return this.scale;
    }

    public float rotation() {
        return this.rotation;
    }
}

