/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class BlockPaintColor
implements IDataSerializable.Immutable {
    public static final BlockPaintColor WHITE = new BlockPaintColor();
    public static final IDataCodec<BlockPaintColor> CODEC = IDataCodec.COMPOUND_TAG.serializer(BlockPaintColor::new);
    protected SkinPaintColor paintColor;
    protected EnumMap<Side, SkinPaintColor> paintColors;

    public BlockPaintColor() {
        this(SkinPaintColor.WHITE);
    }

    public BlockPaintColor(SkinPaintColor paintColor) {
        this.paintColor = paintColor;
    }

    public BlockPaintColor(IDataSerializer serializer) {
        this.paintColor = serializer.read(CodingKeys.ALL);
        this.paintColors = null;
        for (Map.Entry<Side, IDataSerializerKey<SkinPaintColor>> entry : CodingKeys.SIDES.entrySet()) {
            SkinPaintColor paintColor = serializer.read(entry.getValue());
            if (paintColor == null) continue;
            if (this.paintColors == null) {
                this.paintColors = new EnumMap(Side.class);
            }
            this.paintColors.put(entry.getKey(), paintColor);
        }
        this.mergePaintColorIfNeeded();
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.ALL, this.paintColor);
        if (this.paintColors == null) {
            return;
        }
        for (Map.Entry<Side, IDataSerializerKey<SkinPaintColor>> entry : CodingKeys.SIDES.entrySet()) {
            SkinPaintColor paintColor = this.paintColors.get((Object)entry.getKey());
            if (paintColor == null) continue;
            serializer.write(entry.getValue(), paintColor);
        }
    }

    public void putAll(SkinPaintColor paintColor) {
        this.paintColor = paintColor;
        this.paintColors = null;
    }

    public void put(OpenDirection dir, SkinPaintColor paintColor) {
        if (this.paintColors == null) {
            if (Objects.equals(this.paintColor, paintColor)) {
                return;
            }
            this.paintColors = this.getPaintColors(this.paintColor);
            this.paintColor = null;
        }
        Side side = Side.of(dir);
        if (paintColor != null) {
            this.paintColors.put(side, paintColor);
        } else {
            this.paintColors.remove((Object)side);
        }
        this.mergePaintColorIfNeeded();
    }

    public SkinPaintColor get(OpenDirection dir) {
        return this.getOrDefault(dir, null);
    }

    public SkinPaintColor getOrDefault(OpenDirection dir, SkinPaintColor defaultValue) {
        if (this.paintColor != null) {
            return this.paintColor;
        }
        if (this.paintColors != null) {
            return this.paintColors.getOrDefault((Object)Side.of(dir), defaultValue);
        }
        return defaultValue;
    }

    public Collection<SkinPaintColor> values() {
        if (this.paintColor != null) {
            return Collections.singleton(this.paintColor);
        }
        if (this.paintColors != null) {
            return this.paintColors.values();
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockPaintColor)) {
            return false;
        }
        BlockPaintColor that = (BlockPaintColor)o;
        return Objects.equals(this.paintColor, that.paintColor) && Objects.equals(this.paintColors, that.paintColors);
    }

    public int hashCode() {
        return Objects.hash(this.paintColor, this.paintColors);
    }

    public BlockPaintColor copy() {
        BlockPaintColor newValue = new BlockPaintColor(this.paintColor);
        if (this.paintColors != null) {
            newValue.paintColors = new EnumMap<Side, SkinPaintColor>(this.paintColors);
        }
        return newValue;
    }

    public boolean isEmpty() {
        if (this.paintColors != null) {
            return this.paintColors.isEmpty();
        }
        return this.paintColor == null;
    }

    public boolean isPureColor() {
        return this.paintColor != null;
    }

    private void mergePaintColorIfNeeded() {
        if (this.paintColors == null) {
            return;
        }
        int total = 0;
        SkinPaintColor lastColor = null;
        for (SkinPaintColor paintColor : this.paintColors.values()) {
            if (lastColor != null && !lastColor.equals(paintColor)) {
                return;
            }
            lastColor = paintColor;
            ++total;
        }
        if (total == 6) {
            this.paintColor = lastColor;
            this.paintColors = null;
        }
    }

    private EnumMap<Side, SkinPaintColor> getPaintColors(SkinPaintColor paintColor) {
        EnumMap<Side, SkinPaintColor> paintColors = new EnumMap<Side, SkinPaintColor>(Side.class);
        if (paintColor != null) {
            for (Side side : Side.values()) {
                paintColors.put(side, paintColor);
            }
        }
        return paintColors;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<SkinPaintColor> ALL = IDataSerializerKey.create("All", SkinPaintColor.CODEC, null);
        public static final Map<Side, IDataSerializerKey<SkinPaintColor>> SIDES = Collections.immutableMap(it -> {
            for (Side side : Side.values()) {
                String name = side.serializedName;
                IDataSerializerKey<Object> key = IDataSerializerKey.create(name, SkinPaintColor.CODEC, null);
                it.put((Object)side, key);
            }
        });

        private CodingKeys() {
        }
    }

    public static enum Side {
        DOWN("Down", OpenDirection.DOWN),
        UP("Up", OpenDirection.UP),
        FRONT("Front", OpenDirection.NORTH),
        BACK("Back", OpenDirection.SOUTH),
        LEFT("Left", OpenDirection.WEST),
        RIGHT("Right", OpenDirection.EAST);

        final String serializedName;
        final OpenDirection direction;

        private Side(String serializedName, OpenDirection direction) {
            this.serializedName = serializedName;
            this.direction = direction;
        }

        public static Side of(OpenDirection direction) {
            for (Side value : Side.values()) {
                if (value.direction != direction) continue;
                return value;
            }
            return DOWN;
        }

        public String serializedName() {
            return this.serializedName;
        }

        public OpenDirection direction() {
            return this.direction;
        }
    }
}

