/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.slot;

import moe.plushie.armourers_workshop.api.common.IItemTag;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.data.slot.ItemMatcher;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItemMatchers;
import moe.plushie.armourers_workshop.init.ModItemTags;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum ItemOverrideType {
    SWORD("sword", ModItemTags.SWORDS, ModItemMatchers.SWORDS),
    SHIELD("shield", ModItemTags.SHIELDS, ModItemMatchers.SHIELDS),
    BOW("bow", ModItemTags.BOWS, ModItemMatchers.BOWS),
    TRIDENT("trident", ModItemTags.TRIDENTS, ModItemMatchers.TRIDENTS),
    PICKAXE("pickaxe", ModItemTags.PICKAXES, ModItemMatchers.PICKAXES),
    AXE("axe", ModItemTags.AXES, ModItemMatchers.AXES),
    SHOVEL("shovel", ModItemTags.SHOVELS, ModItemMatchers.SHOVELS),
    HOE("hoe", ModItemTags.HOES, ModItemMatchers.HOES),
    BOAT("boat", ModItemTags.BOATS, null),
    MINECART("minecart", ModItemTags.MINECARTS, null),
    FISHING_ROD("fishing_rod", ModItemTags.FISHING_RODS, null),
    BACKPACK("backpack", ModItemTags.BACKPACKS, null),
    HORSE_ARMOR("horse_armor", ModItemTags.HORSE_ARMORS, null),
    ITEM("item", null, null);

    private final IRegistryHolder<IItemTag> tag;
    private final String serializedName;
    private final ItemMatcher matcher;

    private ItemOverrideType(String serializedName, IRegistryHolder<IItemTag> tag, ItemMatcher matcher) {
        this.serializedName = serializedName;
        this.tag = tag;
        this.matcher = matcher;
    }

    @Nullable
    public static ItemOverrideType of(String name) {
        for (ItemOverrideType overrideType : ItemOverrideType.values()) {
            if (!overrideType.serializedName().equals(name)) continue;
            return overrideType;
        }
        return null;
    }

    public boolean isOverrideItem(ItemStack itemStack) {
        if (this == ITEM) {
            return true;
        }
        IResourceLocation registryName = TypedRegistry.findKey(itemStack.func_77973_b());
        if (ModConfig.Common.overrides.contains(this.serializedName + ":" + registryName)) {
            return true;
        }
        if (this.tag != null && ((IItemTag)this.tag.get()).contains(itemStack)) {
            return true;
        }
        if (this.matcher != null) {
            return this.matcher.test(registryName, itemStack);
        }
        return false;
    }

    public String serializedName() {
        return this.serializedName;
    }
}

