/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import moe.plushie.armourers_workshop.api.common.IEntityDataBuilder;
import moe.plushie.armourers_workshop.api.common.IEntityHandler;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractLivingEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.EntityDimensions.ABI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix16;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.option.MannequinToolOptions;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntitySerializers;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MannequinEntity
extends AbstractLivingEntity.ArmorStand
implements IEntityHandler,
IDataSerializable.Mutable {
    public static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    public static final EntitySize MARKER_DIMENSIONS = EntitySize.func_220311_c((float)0.0f, (float)0.0f);
    public static final EntitySize BABY_DIMENSIONS = ABI.withEyeHeight(EntitySize.func_220314_b((float)0.5f, (float)1.0f), 0.88f);
    public static final EntitySize STANDING_DIMENSIONS = ABI.withEyeHeight(EntitySize.func_220314_b((float)0.6f, (float)1.88f), 1.62f);
    public static final DataParameter<Boolean> DATA_IS_CHILD = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Boolean> DATA_IS_FLYING = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Boolean> DATA_IS_GHOST = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Boolean> DATA_IS_VISIBLE = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Float> DATA_SCALE = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.FLOAT);
    public static final DataParameter<Boolean> DATA_EXTRA_RENDERER = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Boolean> DATA_NO_GRAVITY = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<EntityTextureDescriptor> DATA_TEXTURE = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE);
    public static final DataParameter<EntityTextureDescriptor.Model> DATA_TEXTURE_MODEL = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE_MODEL);
    private boolean isDropEquipment = false;
    private AxisAlignedBB boundingBoxForCulling;

    public MannequinEntity(EntityType<? extends MannequinEntity> entityType, World level) {
        super((EntityType<? extends AbstractLivingEntity.ArmorStand>)entityType, level);
    }

    @Override
    protected void defineSynchedData(IEntityDataBuilder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHILD, false);
        builder.define(DATA_IS_FLYING, false);
        builder.define(DATA_IS_GHOST, false);
        builder.define(DATA_IS_VISIBLE, true);
        builder.define(DATA_EXTRA_RENDERER, true);
        builder.define(DATA_NO_GRAVITY, true);
        builder.define(DATA_SCALE, Float.valueOf(1.0f));
        builder.define(DATA_TEXTURE, EntityTextureDescriptor.EMPTY);
        builder.define(DATA_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.deserialize(new TagSerializer(tag));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.serialize(new TagSerializer(tag));
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.IS_SMALL, (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CHILD));
        serializer.write(CodingKeys.IS_FLYING, (Boolean)this.field_70180_af.func_187225_a(DATA_IS_FLYING));
        serializer.write(CodingKeys.IS_GHOST, (Boolean)this.field_70180_af.func_187225_a(DATA_IS_GHOST));
        serializer.write(CodingKeys.IS_VISIBLE, (Boolean)this.field_70180_af.func_187225_a(DATA_IS_VISIBLE));
        serializer.write(CodingKeys.EXTRA_RENDER, (Boolean)this.field_70180_af.func_187225_a(DATA_EXTRA_RENDERER));
        serializer.write(CodingKeys.NO_GRAVITY, (Boolean)this.field_70180_af.func_187225_a(DATA_NO_GRAVITY));
        serializer.write(CodingKeys.SCALE, (Float)this.field_70180_af.func_187225_a(DATA_SCALE));
        serializer.write(CodingKeys.TEXTURE, (EntityTextureDescriptor)this.field_70180_af.func_187225_a(DATA_TEXTURE));
        serializer.write(CodingKeys.TEXTURE_MODEL, (EntityTextureDescriptor.Model)((Object)this.field_70180_af.func_187225_a(DATA_TEXTURE_MODEL)));
        serializer.write(CodingKeys.POSE, this.saveCustomPose());
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.field_70180_af.func_187227_b(DATA_IS_CHILD, (Object)serializer.read(CodingKeys.IS_SMALL));
        this.field_70180_af.func_187227_b(DATA_IS_FLYING, (Object)serializer.read(CodingKeys.IS_FLYING));
        this.field_70180_af.func_187227_b(DATA_IS_GHOST, (Object)serializer.read(CodingKeys.IS_GHOST));
        this.field_70180_af.func_187227_b(DATA_IS_VISIBLE, (Object)serializer.read(CodingKeys.IS_VISIBLE));
        this.field_70180_af.func_187227_b(DATA_EXTRA_RENDERER, (Object)serializer.read(CodingKeys.EXTRA_RENDER));
        this.field_70180_af.func_187227_b(DATA_NO_GRAVITY, (Object)serializer.read(CodingKeys.NO_GRAVITY));
        this.field_70180_af.func_187227_b(DATA_SCALE, (Object)serializer.read(CodingKeys.SCALE));
        this.field_70180_af.func_187227_b(DATA_TEXTURE, (Object)serializer.read(CodingKeys.TEXTURE));
        this.field_70180_af.func_187227_b(DATA_TEXTURE_MODEL, (Object)serializer.read(CodingKeys.TEXTURE_MODEL));
        this.readCustomPose(serializer.read(CodingKeys.POSE));
        this.func_213323_x_();
        this.refreshPhysics();
    }

    public void func_184206_a(DataParameter<?> dataParameter) {
        if (DATA_IS_CHILD.equals(dataParameter)) {
            this.func_213323_x_();
        }
        if (DATA_SCALE.equals(dataParameter)) {
            this.func_213323_x_();
        }
        if (DATA_NO_GRAVITY.equals(dataParameter)) {
            this.refreshPhysics();
        }
        super.func_184206_a(dataParameter);
    }

    public boolean isModelVisible() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_VISIBLE);
    }

    public void setModelVisible(boolean value) {
        this.field_70180_af.func_187227_b(DATA_IS_VISIBLE, (Object)value);
    }

    public float func_213355_cm() {
        return ((Float)this.field_70180_af.func_187225_a(DATA_SCALE)).floatValue();
    }

    public boolean func_175410_n() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CHILD);
    }

    public boolean func_189652_ae() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_NO_GRAVITY);
    }

    public void func_189654_d(boolean bl) {
        this.field_70180_af.func_187227_b(DATA_NO_GRAVITY, (Object)bl);
    }

    public boolean isFakeFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_FLYING);
    }

    public boolean func_241845_aY() {
        return this.func_70089_S() && (Boolean)this.field_70180_af.func_187225_a(DATA_IS_GHOST) == false;
    }

    @Override
    public EntitySize getDefaultDimensions(Pose pose) {
        if (this.func_181026_s()) {
            return MARKER_DIMENSIONS;
        }
        EntitySize entitySize = STANDING_DIMENSIONS;
        if (this.func_70631_g_()) {
            entitySize = BABY_DIMENSIONS;
        }
        return entitySize;
    }

    @Override
    public ItemStack getCustomPickResult(RayTraceResult target) {
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MANNEQUIN.get());
        if (EnvironmentExecutorIO.hasControlDown()) {
            CompoundNBT entityTag = new CompoundNBT();
            entityTag.func_74778_a("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            this.func_213281_b(entityTag);
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
        }
        return itemStack;
    }

    public void func_181013_g(float f) {
        super.func_181013_g(f);
        PropertyProvider.setYRot((Entity)this, f);
        this.field_70761_aq = f;
    }

    public void func_70107_b(double d, double e, double f) {
        super.func_70107_b(d, e, f);
        this.boundingBoxForCulling = null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.isDropEquipment = false;
        boolean flag = this.func_70089_S();
        boolean flag1 = super.func_70097_a(source, amount);
        World level = PropertyProvider.getLevel((Entity)this);
        if (!this.isDropEquipment && flag != this.func_70089_S() && level instanceof ServerWorld) {
            this.brokenByAnything((ServerWorld)level, source);
        }
        return flag1;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d pos, Hand hand) {
        if (this.func_181026_s()) {
            return ActionResultType.PASS;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (Fix16.is(itemStack, (Item)ModItems.MANNEQUIN_TOOL.get())) {
            return ActionResultType.PASS;
        }
        if (Fix16.is(itemStack, Items.field_151057_cb)) {
            return itemStack.func_111282_a_(player, (LivingEntity)this, hand);
        }
        if (player.func_226563_dT_()) {
            if (EnvironmentExecutorIO.hasControlDown()) {
                return super.func_184199_a(player, pos, hand);
            }
            double ry = OpenMath.getAngleDegrees(player.func_226277_ct_(), player.func_226281_cx_(), this.func_226277_ct_(), this.func_226281_cx_()) + 90.0;
            Rotations rotations = this.func_175408_t();
            float yRot = PropertyProvider.getYRot((Entity)this);
            this.func_175424_b(new Rotations(rotations.func_179415_b(), (float)ry - yRot, rotations.func_179413_d()));
            return ActionResultType.func_233537_a_((boolean)PropertyProvider.getLevel((Entity)this).func_201670_d());
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null && wardrobe.isEditable(player)) {
            ((IMenuType)ModMenuTypes.WARDROBE.get()).openMenu(player, wardrobe);
            return ActionResultType.func_233537_a_((boolean)PropertyProvider.getLevel((Entity)this).func_201670_d());
        }
        return ActionResultType.PASS;
    }

    @Override
    public void brokenByPlayer(ServerWorld serverLevel, DamageSource source) {
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.PropertyProvider.getAbilities((PlayerEntity)player).field_75098_d) {
                EntityData entityData = new EntityData();
                entityData.setScale(this.func_213355_cm());
                entityData.setTexture(this.getTextureDescriptor());
                Block.func_180635_a((World)PropertyProvider.getLevel((Entity)this), (BlockPos)this.func_233580_cy_(), (ItemStack)entityData.itemStack());
            }
        }
        this.brokenByAnything(serverLevel, source);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        this.isDropEquipment = true;
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null) {
            wardrobe.dropAll(arg_0 -> ((MannequinEntity)this).func_199701_a_(arg_0));
        }
    }

    protected void refreshPhysics() {
        this.field_70145_X = !this.hasPhysics();
    }

    protected boolean hasPhysics() {
        return !this.func_181026_s() && !this.func_189652_ae();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        if (this.boundingBoxForCulling != null) {
            return this.boundingBoxForCulling;
        }
        float f = this.func_213355_cm();
        this.boundingBoxForCulling = this.func_174813_aQ().func_72314_b((double)(f * 3.0f), (double)(f * 2.0f), (double)(f * 2.5f));
        return this.boundingBoxForCulling;
    }

    public EntityTextureDescriptor getTextureDescriptor() {
        return (EntityTextureDescriptor)this.field_70180_af.func_187225_a(DATA_TEXTURE);
    }

    public void setTextureDescriptor(EntityTextureDescriptor newValue) {
        this.field_70180_af.func_187227_b(DATA_TEXTURE, (Object)newValue);
    }

    public EntityTextureDescriptor.Model getTextureModel() {
        return (EntityTextureDescriptor.Model)((Object)this.field_70180_af.func_187225_a(DATA_TEXTURE_MODEL));
    }

    public void setTextureModel(EntityTextureDescriptor.Model newValue) {
        this.field_70180_af.func_187227_b(DATA_TEXTURE_MODEL, (Object)newValue);
    }

    public boolean isExtraRenderer() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_EXTRA_RENDERER);
    }

    public void setExtraRenderer(boolean value) {
        this.field_70180_af.func_187227_b(DATA_EXTRA_RENDERER, (Object)value);
    }

    public IInventory getInventory() {
        return new Inventory(new ItemStack[]{this.func_184614_ca(), this.func_184592_cb()}){

            public void func_70299_a(int index, ItemStack itemStack) {
                super.func_70299_a(index, itemStack);
                MannequinEntity.this.func_184201_a(EquipmentSlotType.values()[index], itemStack);
            }
        };
    }

    public CompoundNBT saveCustomPose() {
        TagSerializer serializer = new TagSerializer();
        serializer.write(CodingKeys.POSE_HEAD, (Rotations)this.field_70180_af.func_187225_a(field_184802_b));
        serializer.write(CodingKeys.POSE_BODY, (Rotations)this.field_70180_af.func_187225_a(field_184803_c));
        serializer.write(CodingKeys.POSE_LEFT_ARM, (Rotations)this.field_70180_af.func_187225_a(field_184804_d));
        serializer.write(CodingKeys.POSE_RIGHT_ARM, (Rotations)this.field_70180_af.func_187225_a(field_184805_e));
        serializer.write(CodingKeys.POSE_LEFT_LEG, (Rotations)this.field_70180_af.func_187225_a(field_184806_f));
        serializer.write(CodingKeys.POSE_RIGHT_LEG, (Rotations)this.field_70180_af.func_187225_a(field_184807_g));
        return serializer.tag();
    }

    public void readCustomPose(CompoundNBT tag) {
        TagSerializer serializer = new TagSerializer(tag);
        this.func_175415_a(serializer.read(CodingKeys.POSE_HEAD));
        this.func_175424_b(serializer.read(CodingKeys.POSE_BODY));
        this.func_175405_c(serializer.read(CodingKeys.POSE_LEFT_ARM));
        this.func_175428_d(serializer.read(CodingKeys.POSE_RIGHT_ARM));
        this.func_175417_e(serializer.read(CodingKeys.POSE_LEFT_LEG));
        this.func_175427_f(serializer.read(CodingKeys.POSE_RIGHT_LEG));
    }

    public void saveMannequinToolData(CompoundNBT entityTag) {
        this.serialize(new TagSerializer(entityTag));
    }

    public void readMannequinToolData(CompoundNBT entityTag, ItemStack itemStack) {
        INBT oldValue;
        CompoundNBT newEntityTag = new CompoundNBT();
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_OPTION).booleanValue()) {
            newEntityTag.func_197643_a(entityTag);
            newEntityTag.func_82580_o(CodingKeys.SCALE.name());
            newEntityTag.func_82580_o(CodingKeys.POSE.name());
            newEntityTag.func_82580_o(CodingKeys.TEXTURE.name());
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_SCALE).booleanValue() && (oldValue = entityTag.func_74781_a(CodingKeys.SCALE.name())) != null) {
            newEntityTag.func_218657_a(CodingKeys.SCALE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_ROTATION).booleanValue()) {
            oldValue = OptionalAPI.getOptionalCompound(entityTag, CodingKeys.POSE.name()).orElseGet(CompoundNBT::new);
            if (ToolAPI.get(itemStack, MannequinToolOptions.MIRROR_MODE).booleanValue() && !oldValue.isEmpty()) {
                TagSerializer poseSerializer = new TagSerializer(oldValue.func_74737_b());
                poseSerializer.write(CodingKeys.POSE_HEAD, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_HEAD)));
                poseSerializer.write(CodingKeys.POSE_BODY, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_BODY)));
                poseSerializer.write(CodingKeys.POSE_LEFT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_ARM)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_ARM)));
                poseSerializer.write(CodingKeys.POSE_LEFT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_LEG)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_LEG)));
                oldValue = poseSerializer.tag();
            }
            newEntityTag.func_218657_a(CodingKeys.POSE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_TEXTURE).booleanValue() && (oldValue = entityTag.func_74781_a(CodingKeys.TEXTURE.name())) != null) {
            newEntityTag.func_218657_a(CodingKeys.TEXTURE.name(), oldValue);
        }
        this.deserialize(new TagSerializer(newEntityTag));
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Boolean> IS_SMALL = IDataSerializerKey.create("Small", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_FLYING = IDataSerializerKey.create("Flying", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_GHOST = IDataSerializerKey.create("Ghost", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_VISIBLE = IDataSerializerKey.create("ModelVisible", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> EXTRA_RENDER = IDataSerializerKey.create("ExtraRender", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> NO_GRAVITY = IDataSerializerKey.create("NoGravity", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Float> SCALE = IDataSerializerKey.create("Scale", IDataCodec.FLOAT, Float.valueOf(1.0f));
        public static final IDataSerializerKey<EntityTextureDescriptor> TEXTURE = IDataSerializerKey.create("Texture", EntityTextureDescriptor.CODEC, EntityTextureDescriptor.EMPTY);
        public static final IDataSerializerKey<EntityTextureDescriptor.Model> TEXTURE_MODEL = IDataSerializerKey.create("TextureModel", DataSerializers.ENTITY_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
        public static final IDataSerializerKey<CompoundNBT> POSE = IDataSerializerKey.create("Pose", IDataCodec.COMPOUND_TAG, new CompoundNBT());
        public static final IDataSerializerKey<Rotations> POSE_HEAD = IDataSerializerKey.create("Head", EntityData.access$100(), DEFAULT_HEAD_POSE);
        public static final IDataSerializerKey<Rotations> POSE_BODY = IDataSerializerKey.create("Body", EntityData.access$100(), DEFAULT_BODY_POSE);
        public static final IDataSerializerKey<Rotations> POSE_LEFT_ARM = IDataSerializerKey.create("LeftArm", EntityData.access$100(), DEFAULT_LEFT_ARM_POSE);
        public static final IDataSerializerKey<Rotations> POSE_RIGHT_ARM = IDataSerializerKey.create("RightArm", EntityData.access$100(), DEFAULT_RIGHT_ARM_POSE);
        public static final IDataSerializerKey<Rotations> POSE_LEFT_LEG = IDataSerializerKey.create("LeftLeg", EntityData.access$100(), DEFAULT_LEFT_LEG_POSE);
        public static final IDataSerializerKey<Rotations> POSE_RIGHT_LEG = IDataSerializerKey.create("RightLeg", EntityData.access$100(), DEFAULT_RIGHT_LEG_POSE);

        private CodingKeys() {
        }
    }

    public static class EntityData {
        private static final IDataCodec<Rotations> ROTATIONS_CODEC = IDataCodec.FLOAT.listOf().xmap(it -> new Rotations(((Float)it.get(0)).floatValue(), ((Float)it.get(1)).floatValue(), ((Float)it.get(2)).floatValue()), it -> Collections.newList(Float.valueOf(it.func_179415_b()), Float.valueOf(it.func_179416_c()), Float.valueOf(it.func_179413_d())));
        private final TagSerializer serializer;

        public EntityData() {
            this.serializer = new TagSerializer();
        }

        public EntityData(CompoundNBT tag) {
            this.serializer = new TagSerializer(tag);
        }

        private static Rotations mirror(Rotations rot) {
            return new Rotations(rot.func_179415_b(), -rot.func_179416_c(), -rot.func_179413_d());
        }

        public void setScale(float scale) {
            this.serializer.write(CodingKeys.SCALE, Float.valueOf(scale));
        }

        public float scale() {
            return this.serializer.read(CodingKeys.SCALE).floatValue();
        }

        public void setTexture(EntityTextureDescriptor texture) {
            this.serializer.write(CodingKeys.TEXTURE, texture);
        }

        public EntityTextureDescriptor texture() {
            return this.serializer.read(CodingKeys.TEXTURE);
        }

        public boolean isSmall() {
            return this.serializer.read(CodingKeys.IS_SMALL);
        }

        public CompoundNBT entityTag() {
            CompoundNBT entityTag = this.serializer.tag().func_74737_b();
            if (!entityTag.isEmpty()) {
                entityTag.func_74778_a("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            }
            return entityTag;
        }

        public ItemStack itemStack() {
            ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MANNEQUIN.get());
            CompoundNBT entityTag = this.entityTag();
            if (!entityTag.isEmpty()) {
                ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
            }
            return itemStack;
        }

        static /* synthetic */ IDataCodec access$100() {
            return ROTATIONS_CODEC;
        }
    }
}

