/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.common.IItemGroupProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GiftSackItem
extends FlavouredItem
implements IItemGroupProvider,
IItemTintColorProvider {
    public GiftSackItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack of(Holiday holiday) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.GIFT_SACK.get());
        ComponentAPI.set(stack, (IDataComponentType)ModDataComponents.HOLIDAY.get(), holiday);
        if (holiday.handler() != null) {
            ComponentAPI.set(stack, (IDataComponentType)ModDataComponents.GIFT_COLOR_BG.get(), holiday.handler().backgroundColor());
            ComponentAPI.set(stack, (IDataComponentType)ModDataComponents.GIFT_COLOR_FG.get(), holiday.handler().foregroundColor());
        }
        return stack;
    }

    public static ItemStack getGift(ItemStack itemStack, PlayerEntity player) {
        Holiday holiday = (Holiday)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.HOLIDAY.get());
        if (holiday != null && holiday.handler() != null) {
            return holiday.handler().getGift(player);
        }
        return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.GIFT.get(), ItemStack.field_190927_a);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        ItemStack giftStack = GiftSackItem.getGift(itemStack, player);
        if (giftStack.func_190926_b()) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (!level.func_201670_d()) {
            if (PropertyProvider.getInventory(player).func_70441_a(giftStack)) {
                itemStack.func_190918_g(1);
            } else {
                SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.inventoryFull", new Object[0]));
            }
        }
        return ActionResult.func_233538_a_((Object)itemStack, (boolean)level.func_201670_d());
    }

    @Override
    public void fillItemGroup(List<ItemStack> results, IItemGroup group) {
        for (Holiday holiday : ModHolidays.holidays()) {
            if (holiday.handler() == null) continue;
            results.add(GiftSackItem.of(holiday));
        }
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        if (index == 1) {
            return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.GIFT_COLOR_FG.get(), 0x333333) | 0xFF000000;
        }
        return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.GIFT_COLOR_BG.get(), 0xFFFFFF) | 0xFF000000;
    }
}

