/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.api.core.math.IVector3i;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class OpenVector3i
implements Comparable<OpenVector3i>,
IVector3i {
    public static final OpenVector3i ZERO = new OpenVector3i(0, 0, 0);
    public int x;
    public int y;
    public int z;
    public static final IDataCodec<OpenVector3i> CODEC = IDataCodec.INT.listOf().xmap(OpenVector3i::new, OpenVector3i::toList);

    public OpenVector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public OpenVector3i(double x, double y, double z) {
        this(OpenMath.floori(x), OpenMath.floori(y), OpenMath.floori(z));
    }

    public OpenVector3i(IVector3f pos) {
        this(pos.x(), pos.y(), pos.z());
    }

    public OpenVector3i(IVector3i pos) {
        this(pos.x(), pos.y(), pos.z());
    }

    public OpenVector3i(List<Integer> values) {
        this(values.get(0), values.get(1), values.get(2));
    }

    @Override
    public int compareTo(OpenVector3i v) {
        int dy = this.y() - v.y();
        if (dy != 0) {
            return dy;
        }
        int dz = this.z() - v.z();
        if (dz != 0) {
            return dz;
        }
        return this.x() - v.x();
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    public OpenVector3i above() {
        return this.above(1);
    }

    public OpenVector3i above(int step) {
        return this.relative(OpenDirection.UP, step);
    }

    public OpenVector3i below() {
        return this.below(1);
    }

    public OpenVector3i below(int step) {
        return this.relative(OpenDirection.DOWN, step);
    }

    public OpenVector3i relative(OpenDirection dir, int i) {
        if (i == 0) {
            return this;
        }
        return new OpenVector3i(this.x() + dir.stepX() * i, this.y() + dir.stepY() * i, this.z() + dir.stepZ() * i);
    }

    public OpenVector3i cross(OpenVector3i pos) {
        return new OpenVector3i(this.y() * pos.z() - this.z() * pos.y(), this.z() * pos.x() - this.x() * pos.z(), this.x() * pos.y() - this.y() * pos.x());
    }

    public boolean closerThan(OpenVector3i pos, double d) {
        return this.distSqr(pos.x(), pos.y(), pos.z(), false) < d * d;
    }

    public double distSqr(OpenVector3i v) {
        return this.distSqr(v.x(), v.y(), v.z(), true);
    }

    public double distSqr(double tx, double ty, double tz, boolean p_218140_7_) {
        double d0 = p_218140_7_ ? 0.5 : 0.0;
        double d1 = (double)this.x() + d0 - tx;
        double d2 = (double)this.y() + d0 - ty;
        double d3 = (double)this.z() + d0 - tz;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public int distManhattan(OpenVector3i pos) {
        float f = Math.abs(pos.x() - this.x());
        float f1 = Math.abs(pos.y() - this.y());
        float f2 = Math.abs(pos.z() - this.z());
        return (int)(f + f1 + f2);
    }

    public List<Integer> toList() {
        return Collections.newList(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenVector3i)) {
            return false;
        }
        OpenVector3i that = (OpenVector3i)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return OpenMath.format("(%d %d %d)", this.x, this.y, this.z);
    }
}

