/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.ArrayList;
import java.util.Set;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.DyeTableBlockEntity;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.menu.SkinSlot;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinDyeType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class DyeTableMenu
extends AbstractBlockEntityMenu<DyeTableBlockEntity> {
    private final SkinPaintType[] paintTypes = new SkinPaintType[]{SkinPaintTypes.DYE_1, SkinPaintTypes.DYE_2, SkinPaintTypes.DYE_3, SkinPaintTypes.DYE_4, SkinPaintTypes.DYE_5, SkinPaintTypes.DYE_6, SkinPaintTypes.DYE_7, SkinPaintTypes.DYE_8};
    private final IInventory inventory;
    private ArrayList<SkinPaintType> lockedPaintTypes = new ArrayList();

    public DyeTableMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IGlobalPos access) {
        super((ContainerType)menuType, block, containerId, access);
        this.inventory = ((DyeTableBlockEntity)this.blockEntity).getInventory();
        this.addPlayerSlots((IInventory)playerInventory, 8, 108);
        this.addCustomSlots(this.inventory, 68, 36, 22, 22);
        this.addInputSlot(this.inventory, 8, 26, 23);
        this.addOutputSlot(this.inventory, 9, 26, 69);
    }

    public void reload(Set<SkinDyeType> dyeTypes) {
        this.lockedPaintTypes = dyeTypes != null ? Collections.filter(this.paintTypes, it -> !dyeTypes.contains(it.dyeType())) : new ArrayList();
    }

    public ItemStack inputStack() {
        return this.inventory.func_70301_a(8);
    }

    public ItemStack outputStack() {
        return this.inventory.func_70301_a(9);
    }

    public void setOutputStack(ItemStack itemStack) {
        this.inventory.func_70299_a(9, itemStack);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size() - 1);
    }

    protected void addInputSlot(final IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){

            public boolean func_82869_a(PlayerEntity player) {
                return false;
            }

            public boolean func_75214_a(ItemStack itemStack) {
                return !SkinDescriptor.of(itemStack).isEmpty();
            }

            public void func_75218_e() {
                super.func_75218_e();
                if (inventory.func_70301_a(9).func_190926_b()) {
                    DyeTableMenu.this.loadSkin(this.func_75211_c());
                }
            }
        });
    }

    protected void addOutputSlot(IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){

            public boolean func_75214_a(ItemStack itemStack) {
                return false;
            }

            public void func_75218_e() {
                super.func_75218_e();
                if (!this.func_75216_d()) {
                    DyeTableMenu.this.loadSkin(ItemStack.field_190927_a);
                }
            }
        });
    }

    protected void addCustomSlots(IInventory inventory, int x, int y, int itemWidth, int itemHeight) {
        for (int i = 0; i < this.paintTypes.length; ++i) {
            int ix = x + i % 4 * itemWidth;
            int iy = y + i / 4 * itemHeight;
            this.func_75146_a(new LockableSlot(inventory, i, ix, iy, this.paintTypes[i]));
        }
    }

    protected void loadSkin(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            this.inventory.func_174888_l();
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinPaintScheme scheme = descriptor.paintScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            ItemStack colorStack = ItemStack.field_190927_a;
            SkinPaintColor paintColor = scheme.getColor(this.paintTypes[i]);
            if (paintColor != null) {
                colorStack = new ItemStack((IItemProvider)ModItems.BOTTLE.get());
                ComponentAPI.set(colorStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
            }
            this.inventory.func_70299_a(i, colorStack);
        }
        this.setOutputStack(itemStack.func_77946_l());
    }

    protected void applySkin(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        SkinPaintScheme newScheme = new SkinPaintScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            ItemStack colorStack = this.inventory.func_70301_a(i);
            SkinPaintColor paintColor = (SkinPaintColor)ComponentAPI.get(colorStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
            if (paintColor == null) continue;
            newScheme.setColor(this.paintTypes[i], paintColor);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (newScheme.equals(descriptor.paintScheme())) {
            return;
        }
        descriptor = descriptor.withPaintScheme(newScheme);
        ItemStack newItemStack = itemStack.func_77946_l();
        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor);
        this.setOutputStack(newItemStack);
    }

    public class LockableSlot
    extends SkinSlot {
        private final SkinPaintType paintType;

        public LockableSlot(IInventory inventory, int slot, int x, int y, SkinPaintType paintType) {
            super(inventory, slot, x, y, SkinSlotType.DYE);
            this.paintType = paintType;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (DyeTableMenu.this.inputStack().func_190926_b()) {
                return false;
            }
            return itemStack.func_77973_b() instanceof BottleItem;
        }

        public void func_75218_e() {
            super.func_75218_e();
            DyeTableMenu.this.applySkin(DyeTableMenu.this.outputStack());
        }

        public boolean isLocked() {
            return DyeTableMenu.this.lockedPaintTypes != null && DyeTableMenu.this.lockedPaintTypes.contains(this.paintType);
        }

        public boolean func_111238_b() {
            return !this.isLocked();
        }
    }
}

