/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.Cursor;

public final class Lexer {
    private final StringReader reader;
    private final Cursor cursor = new Cursor();
    private int next;
    private Token token = null;

    Lexer(String source) {
        this.reader = new StringReader(source);
        this.next = this.read();
    }

    public Cursor cursor() {
        return this.cursor;
    }

    public Token current() {
        if (this.token == null) {
            throw new IllegalStateException("No current token, please call next() at least once");
        }
        return this.token;
    }

    public Token next() {
        this.token = this.next0();
        return this.token;
    }

    public void close() {
        this.reader.close();
    }

    private Token next0() {
        Kind tokenKind;
        int c = this.next;
        while (c == 32 || c == 9 || c == 10 || c == 13) {
            c = this.read();
        }
        if (c == -1) {
            return new Token(Kind.EOF, null, this.cursor.index(), this.cursor.index() + 1);
        }
        int start = this.cursor.index();
        if (this.isValidDigit(c)) {
            StringBuilder builder = new StringBuilder(8);
            builder.appendCodePoint(c);
            while (this.isValidDigit(c = this.read())) {
                builder.appendCodePoint(c);
            }
            if (c == 46) {
                builder.append('.');
                while (this.isValidDigit(c = this.read())) {
                    builder.appendCodePoint(c);
                }
            }
            return new Token(Kind.NUMBER, builder.toString(), start, this.cursor.index());
        }
        if (this.isValidForWordStart(c)) {
            Kind kind;
            StringBuilder builder = new StringBuilder();
            do {
                builder.appendCodePoint(c);
            } while (this.isValidForWordContinuation(c = this.read()));
            String word = builder.toString();
            switch (word.toLowerCase()) {
                case "break": {
                    Kind kind2 = Kind.BREAK;
                    break;
                }
                case "continue": {
                    Kind kind2 = Kind.CONTINUE;
                    break;
                }
                case "return": {
                    Kind kind2 = Kind.RETURN;
                    break;
                }
                case "true": {
                    Kind kind2 = Kind.TRUE;
                    break;
                }
                case "false": {
                    Kind kind2 = Kind.FALSE;
                    break;
                }
                default: {
                    Kind kind2 = kind = Kind.IDENTIFIER;
                }
            }
            if (kind != Kind.IDENTIFIER) {
                word = null;
            }
            return new Token(kind, word, start, this.cursor.index());
        }
        if (c == 39) {
            StringBuilder value = new StringBuilder(16);
            while (true) {
                if ((c = this.read()) == -1) {
                    return new Token(Kind.ERROR, "Found end-of-file before closing quote", start, this.cursor.index());
                }
                if (c == 39) break;
                value.appendCodePoint(c);
            }
            this.read();
            return new Token(Kind.STRING, value.toString(), start, this.cursor.index());
        }
        int c1 = -2;
        String value = null;
        switch (c) {
            case 33: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.BANGEQ;
                    break;
                }
                kind = Kind.BANG;
                break;
            }
            case 38: {
                Kind kind;
                c1 = this.read();
                if (c1 == 38) {
                    this.read();
                    kind = Kind.AMPAMP;
                    break;
                }
                value = "Unexpected token '" + (char)c1 + "', expected '&' (Molang doesn't support bitwise operators)";
                kind = Kind.ERROR;
                break;
            }
            case 124: {
                Kind kind;
                c1 = this.read();
                if (c1 == 124) {
                    this.read();
                    kind = Kind.BARBAR;
                    break;
                }
                value = "Unexpected token '" + (char)c1 + "', expected '|' (Molang doesn't support bitwise operators)";
                kind = Kind.ERROR;
                break;
            }
            case 60: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.LTE;
                    break;
                }
                kind = Kind.LT;
                break;
            }
            case 62: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.GTE;
                    break;
                }
                kind = Kind.GT;
                break;
            }
            case 61: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.EQEQ;
                    break;
                }
                kind = Kind.EQ;
                break;
            }
            case 45: {
                Kind kind;
                c1 = this.read();
                if (c1 == 62) {
                    this.read();
                    kind = Kind.ARROW;
                    break;
                }
                if (c1 == 61) {
                    this.read();
                    kind = Kind.SUBEQ;
                    break;
                }
                kind = Kind.SUB;
                break;
            }
            case 63: {
                Kind kind;
                c1 = this.read();
                if (c1 == 63) {
                    int c2 = this.read();
                    if (c2 == 61) {
                        this.read();
                        kind = Kind.QUESQUESEQ;
                        break;
                    }
                    kind = Kind.QUESQUES;
                    break;
                }
                kind = Kind.QUES;
                break;
            }
            case 47: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.SLASHEQ;
                    break;
                }
                kind = Kind.SLASH;
                break;
            }
            case 42: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.STAREQ;
                    break;
                }
                kind = Kind.STAR;
                break;
            }
            case 37: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.MODEQ;
                    break;
                }
                kind = Kind.MOD;
                break;
            }
            case 94: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.POWEQ;
                    break;
                }
                kind = Kind.POW;
                break;
            }
            case 43: {
                Kind kind;
                c1 = this.read();
                if (c1 == 61) {
                    this.read();
                    kind = Kind.PLUSEQ;
                    break;
                }
                kind = Kind.PLUS;
                break;
            }
            case 44: {
                Kind kind = Kind.COMMA;
                break;
            }
            case 46: {
                Kind kind = Kind.DOT;
                break;
            }
            case 40: {
                Kind kind = Kind.LPAREN;
                break;
            }
            case 41: {
                Kind kind = Kind.RPAREN;
                break;
            }
            case 123: {
                Kind kind = Kind.LBRACE;
                break;
            }
            case 125: {
                Kind kind = Kind.RBRACE;
                break;
            }
            case 58: {
                Kind kind = Kind.COLON;
                break;
            }
            case 91: {
                Kind kind = Kind.LBRACKET;
                break;
            }
            case 93: {
                Kind kind = Kind.RBRACKET;
                break;
            }
            case 59: {
                Kind kind = Kind.SEMICOLON;
                break;
            }
            case 34: {
                value = "Unexpected token '\"', expected single quote (') to start a string literal";
                Kind kind = Kind.ERROR;
                break;
            }
            default: {
                value = "Unexpected token '" + (char)c + "': invalid token";
                Kind kind = tokenKind = Kind.ERROR;
            }
        }
        if (c1 == -2) {
            this.read();
        }
        return new Token(tokenKind, value, start, this.cursor.index());
    }

    private int read() {
        try {
            int c = this.reader.read();
            this.cursor.push(c);
            this.next = c;
            return c;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private boolean isValidDigit(int c) {
        return Character.isDigit(c);
    }

    private boolean isValidForWordStart(int c) {
        return 97 <= c && c <= 122 || 65 <= c && c <= 90 || c == 95;
    }

    private boolean isValidForWordContinuation(int c) {
        return this.isValidForWordStart(c) || Character.isDigit(c);
    }

    public static final class Token {
        private final Kind kind;
        private final String value;
        private final int start;
        private final int end;

        public Token(Kind kind, String value, int start, int end) {
            this.kind = kind;
            this.value = value;
            this.start = start;
            this.end = end;
        }

        public Kind kind() {
            return this.kind;
        }

        public String value() {
            return this.value;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public String toString() {
            if (this.kind.hasTag(Kind.Tag.HAS_VALUE)) {
                return (Object)((Object)this.kind) + "(" + this.value + ")";
            }
            return this.kind.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token that = (Token)o;
            return this.start == that.start && this.end == that.end && Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.value, this.start, this.end});
        }
    }

    public static enum Kind {
        EOF,
        ERROR(Tag.HAS_VALUE),
        IDENTIFIER(Tag.HAS_VALUE),
        STRING(Tag.HAS_VALUE),
        NUMBER(Tag.HAS_VALUE),
        TRUE,
        FALSE,
        BREAK,
        CONTINUE,
        RETURN,
        DOT,
        BANG,
        AMPAMP,
        BARBAR,
        LT,
        LTE,
        GT,
        GTE,
        EQ,
        EQEQ,
        BANGEQ,
        STAREQ,
        SLASHEQ,
        PLUSEQ,
        SUBEQ,
        MODEQ,
        POWEQ,
        QUESQUESEQ,
        STAR,
        SLASH,
        PLUS,
        SUB,
        MOD,
        POW,
        LPAREN,
        RPAREN,
        LBRACE,
        RBRACE,
        QUESQUES,
        QUES,
        COLON,
        ARROW,
        LBRACKET,
        RBRACKET,
        COMMA,
        SEMICOLON;

        private final Set<Tag> tags;

        private Kind(Tag ... tags) {
            this.tags = EnumSet.copyOf(Arrays.asList(tags));
        }

        private Kind() {
            this.tags = Collections.emptySet();
        }

        public boolean hasTag(Tag tag) {
            return this.tags.contains((Object)tag);
        }

        public static enum Tag {
            HAS_VALUE;

        }
    }
}

