/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.EntityInfoProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.Fix16;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.Fix1619;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.skin.molang.core.Name;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.VariableStorage;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.BiomeSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.BlockSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BiomeSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BlockSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class EntitySelectorImpl<T extends Entity>
implements EntitySelector,
VariableStorage {
    protected T entity;
    protected VariableStorage variableStorage;
    protected ContextSelectorImpl contextSelector;
    private final BiomeSelectorImpl biomeSelector = new BiomeSelectorImpl();
    private final BlockSelectorImpl blockSelector = new BlockSelectorImpl();

    public EntitySelectorImpl<T> apply(T entity, ContextSelectorImpl contextSelector) {
        this.entity = entity;
        this.contextSelector = contextSelector;
        this.variableStorage = EntityDataStorage.of(entity).variableStorage().map(it -> it.get(contextSelector)).orElse(null);
        return this;
    }

    public T entity() {
        return this.entity;
    }

    @Override
    public double eyeYaw() {
        return this.entity.func_195050_f(this.partialTick());
    }

    @Override
    public double eyePitch() {
        return this.entity.func_195046_g(this.partialTick());
    }

    @Override
    public double headYaw() {
        return EntityInfoProvider.getHeadYaw(this.entity, this.partialTick());
    }

    @Override
    public double headPitch() {
        return EntityInfoProvider.getHeadPatch(this.entity, this.partialTick());
    }

    @Override
    public double x(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).field_70169_q, this.entity.func_226277_ct_());
    }

    @Override
    public double y(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).field_70167_r, this.entity.func_226278_cu_());
    }

    @Override
    public double z(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).field_70166_s, this.entity.func_226281_cx_());
    }

    @Override
    public int cardinalFacing() {
        return this.entity.func_174811_aO().func_176745_a();
    }

    @Override
    public double distanceFromCamera() {
        return this.contextSelector.getCameraDistanceFormEntity((Entity)this.entity);
    }

    @Override
    public double distanceFromMove() {
        return ((Entity)this.entity).field_70140_Q;
    }

    @Override
    public double distanceFromWalk() {
        return ((Entity)this.entity).field_82151_R;
    }

    @Override
    public double yawSpeed() {
        return 20.0f * (PropertyProvider.getYRot(this.entity) - ((Entity)this.entity).field_70126_B);
    }

    @Override
    public double groundSpeed() {
        Vector3d velocity = this.entity.func_213322_ci();
        return 20.0 * Math.sqrt(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c);
    }

    @Override
    public double verticalSpeed() {
        return 20.0 * (this.entity.func_213303_ch().field_72448_b - ((Entity)this.entity).field_70167_r);
    }

    @Override
    public boolean isVehicle() {
        return this.entity.func_184207_aI();
    }

    @Override
    public boolean isPassenger() {
        return this.entity.func_184218_aH();
    }

    @Override
    public boolean isInWater() {
        return this.entity.func_70090_H();
    }

    @Override
    public boolean isInWaterRainOrBubble() {
        return this.entity.func_203008_ap();
    }

    @Override
    public boolean isOnFire() {
        return this.entity.func_70027_ad();
    }

    @Override
    public boolean isOnGround() {
        return Fix1619.onGround(this.entity);
    }

    @Override
    public boolean isSneaking() {
        return Fix1619.onGround(this.entity) && this.entity.func_213283_Z() == Pose.CROUCHING;
    }

    @Override
    public boolean isJumping() {
        return !this.entity.func_184218_aH() && !Fix1619.onGround(this.entity) && !this.entity.func_70090_H();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public boolean isSwimming() {
        return this.entity.func_203007_ba();
    }

    @Override
    public boolean isSleeping() {
        return this.entity.func_213283_Z() == Pose.SLEEPING;
    }

    @Override
    public boolean isSpectator() {
        return this.entity.func_175149_v();
    }

    @Override
    public boolean isUnderWater() {
        return this.entity.func_204231_K();
    }

    @Override
    public boolean isCloseEyes() {
        if (this.isSleeping()) {
            return true;
        }
        double noise = (double)this.entity.func_145782_y() * 0.05;
        double time = (this.contextSelector.animationTicks() + noise) % 4.5;
        return time > 4.25;
    }

    @Override
    public boolean canSeeSky() {
        BlockPos pos;
        World level = PropertyProvider.getLevel(this.entity);
        if (!level.func_226660_f_(pos = this.entity.func_233580_cy_())) {
            return false;
        }
        return level.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos).func_177956_o() <= pos.func_177956_o();
    }

    @Override
    public double ticksFrozen() {
        return Fix16.getTicksFrozen(this.entity);
    }

    @Override
    public double airSupply() {
        return this.entity.func_70086_ai();
    }

    @Override
    @Nullable
    public BiomeSelector biome() {
        World level = PropertyProvider.getLevel(this.entity);
        AbstractRegistryManager.Biome biome = AbstractRegistryManager.getBiome(level, this.entity.func_233580_cy_());
        return this.biomeSelector.apply(biome);
    }

    @Override
    public BlockSelector relativeBlock(int offsetX, int offsetY, int offsetZ) {
        World level = PropertyProvider.getLevel(this.entity);
        double x = this.entity.func_226277_ct_() + (double)offsetX;
        double y = this.entity.func_226277_ct_() + (double)offsetX;
        double z = this.entity.func_226277_ct_() + (double)offsetX;
        BlockState blockState = level.func_180495_p(new BlockPos((int)x, (int)y, (int)z));
        return this.blockSelector.apply(blockState);
    }

    @Override
    public float partialTick() {
        return this.contextSelector.partialTick();
    }

    @Override
    public void setVariable(Name name, Result value) {
        this.variableStorage.setVariable(name, value);
    }

    @Override
    public Result getVariable(Name name) {
        return this.variableStorage.getVariable(name);
    }
}

