/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;

public class SkinSettings {
    public static final SkinSettings EMPTY = new SkinSettings();
    private boolean isPreviewMode = false;
    private int flags = 0;
    private List<OpenRectangle3f> collisionBox;
    private OpenItemTransforms itemTransforms;
    private String securityData;

    public void writeToStream(IOutputStream stream) throws IOException {
        DataWriter writer = new DataWriter(stream);
        writer.write(DataItem.FLAGS, this.flags);
        writer.write(DataItem.ITEM_TRANSFORMS, this.itemTransforms);
        writer.write(DataItem.COLLISION_BOX, this.collisionBox);
        writer.write(DataItem.SECURITY_DATA, this.securityData);
        writer.end();
    }

    public void readFromStream(IInputStream stream) throws IOException {
        DataReader reader = new DataReader(stream);
        this.flags = reader.read(DataItem.FLAGS);
        this.itemTransforms = reader.read(DataItem.ITEM_TRANSFORMS);
        this.collisionBox = reader.read(DataItem.COLLISION_BOX);
        this.securityData = reader.read(DataItem.SECURITY_DATA);
        reader.end();
    }

    public void setEditable(boolean newValue) {
        this.setFlag(0, !newValue);
    }

    public boolean isEditable() {
        return !this.getFlag(0);
    }

    public void setSavable(boolean newValue) {
        this.setFlag(1, !newValue);
    }

    public boolean isSavable() {
        return !this.getFlag(1);
    }

    public void setExportable(boolean newValue) {
        this.setFlag(2, !newValue);
    }

    public boolean isExportable() {
        return !this.getFlag(2);
    }

    public void setEncrypted(boolean newValue) {
        this.setFlag(3, newValue);
    }

    public boolean isEncrypted() {
        return this.getFlag(3) || this.securityData() != null;
    }

    public void setCompressed(boolean newValue) {
        this.setFlag(4, newValue);
    }

    public boolean isCompressed() {
        return this.getFlag(4);
    }

    public void setPreviewMode(boolean isPreviewMode) {
        this.isPreviewMode = isPreviewMode;
    }

    public boolean isPreviewMode() {
        return this.isPreviewMode;
    }

    public void setSecurityData(String securityData) {
        this.securityData = securityData;
    }

    public String securityData() {
        return this.securityData;
    }

    public void setItemTransforms(OpenItemTransforms itemTransforms) {
        this.itemTransforms = itemTransforms;
    }

    public OpenItemTransforms itemTransforms() {
        return this.itemTransforms;
    }

    public void setCollisionBox(List<OpenRectangle3f> collisionBox) {
        this.collisionBox = collisionBox;
    }

    public List<OpenRectangle3f> collisionBox() {
        return this.collisionBox;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinSettings)) {
            return false;
        }
        SkinSettings that = (SkinSettings)o;
        return this.flags == that.flags && Objects.equals(this.collisionBox, that.collisionBox) && Objects.equals(this.itemTransforms, that.itemTransforms) && Objects.equals(this.securityData, that.securityData);
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.collisionBox, this.itemTransforms, this.securityData);
    }

    public String toString() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("editable", this.isEditable());
        properties.put("savable", this.isSavable());
        properties.put("exportable", this.isExportable());
        properties.put("encrypted", this.isEncrypted());
        properties.put("compressed", this.isCompressed());
        if (this.collisionBox != null && !this.collisionBox.isEmpty()) {
            properties.put("collisionBox", this.collisionBox);
        }
        if (this.itemTransforms != null) {
            properties.putAll(this.itemTransforms);
        }
        return properties.toString();
    }

    private void setFlag(int bit, boolean value) {
        this.flags = value ? (this.flags |= 1 << bit) : (this.flags &= ~(1 << bit));
    }

    private boolean getFlag(int bit) {
        return (this.flags & 1 << bit) != 0;
    }

    public SkinSettings copy() {
        SkinSettings settings = new SkinSettings();
        settings.flags = this.flags;
        settings.itemTransforms = this.itemTransforms;
        settings.collisionBox = this.collisionBox;
        settings.securityData = this.securityData;
        return settings;
    }

    public SkinSettings copyWithOptions(SkinFileOptions options) {
        SkinSettings settings = this.copy();
        settings.setEditable(options.getEditable(this.isEditable()));
        settings.setSavable(options.getSavable(this.isSavable()));
        settings.setExportable(options.getExportable(this.isExportable()));
        settings.setEncrypted(options.getEncrypted(this.isEncrypted()));
        settings.setCompressed(options.isCompressed());
        settings.setSecurityData(options.securityData());
        return settings;
    }

    private static class DataWriter {
        private final IOutputStream outputStream;

        DataWriter(IOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        <T> void write(DataItem<T> item, T value) throws IOException {
            if (!Objects.equals(value, item.defaultValue)) {
                this.outputStream.writeVarInt(item.id);
                item.write(value, this.outputStream);
            }
        }

        void end() throws IOException {
            this.outputStream.writeVarInt(0);
        }
    }

    private static abstract class DataItem<T> {
        static final DataItem<Integer> FLAGS = new DataItem<Integer>(1, Integer.valueOf(0)){

            @Override
            Integer read(IInputStream inputStream) throws IOException {
                return inputStream.readInt();
            }

            @Override
            void write(Integer value, IOutputStream outputStream) throws IOException {
                outputStream.writeInt(value);
            }
        };
        static final DataItem<OpenItemTransforms> ITEM_TRANSFORMS = new DataItem<OpenItemTransforms>(2, null){

            @Override
            OpenItemTransforms read(IInputStream inputStream) throws IOException {
                OpenItemTransforms itemTransforms = new OpenItemTransforms();
                int size = inputStream.readVarInt();
                for (int i = 1; i < size; ++i) {
                    String name = inputStream.readString();
                    OpenVector3f translate = inputStream.readVector3f();
                    OpenVector3f rotation = inputStream.readVector3f();
                    OpenVector3f scale = inputStream.readVector3f();
                    itemTransforms.put(name, OpenTransform3f.create(translate, rotation, scale));
                }
                return itemTransforms;
            }

            @Override
            void write(OpenItemTransforms itemTransforms, IOutputStream outputStream) throws IOException {
                outputStream.writeVarInt(itemTransforms.size() + 1);
                for (Map.Entry entry : itemTransforms.entrySet()) {
                    OpenTransform3f transform = (OpenTransform3f)entry.getValue();
                    outputStream.writeString((String)entry.getKey());
                    outputStream.writeVector3f(transform.translate());
                    outputStream.writeVector3f(transform.rotation());
                    outputStream.writeVector3f(transform.scale());
                }
            }
        };
        static final DataItem<List<OpenRectangle3f>> COLLISION_BOX = new DataItem<List<OpenRectangle3f>>(3, null){

            @Override
            List<OpenRectangle3f> read(IInputStream inputStream) throws IOException {
                ArrayList<OpenRectangle3f> collisionBox = new ArrayList<OpenRectangle3f>();
                int size = inputStream.readVarInt();
                for (int i = 1; i < size; ++i) {
                    collisionBox.add(inputStream.readRectangle3f());
                }
                return collisionBox;
            }

            @Override
            void write(List<OpenRectangle3f> collisionBox, IOutputStream outputStream) throws IOException {
                outputStream.writeVarInt(collisionBox.size() + 1);
                for (OpenRectangle3f box : collisionBox) {
                    outputStream.writeRectangle3f(box);
                }
            }
        };
        static final DataItem<String> SECURITY_DATA = new DataItem<String>(4, null){

            @Override
            String read(IInputStream inputStream) throws IOException {
                return inputStream.readString();
            }

            @Override
            void write(String value, IOutputStream outputStream) throws IOException {
                outputStream.writeString(value);
            }
        };
        final int id;
        final T defaultValue;

        private DataItem(int id, T defaultValue) {
            this.id = id;
            this.defaultValue = defaultValue;
        }

        abstract T read(IInputStream var1) throws IOException;

        abstract void write(T var1, IOutputStream var2) throws IOException;
    }

    private static class DataReader {
        private int id = -1;
        private final IInputStream inputStream;

        DataReader(IInputStream inputStream) {
            this.inputStream = inputStream;
        }

        <T> T read(DataItem<T> item) throws IOException {
            if (this.id == -1) {
                this.id = this.inputStream.readVarInt();
            }
            if (this.id == item.id) {
                T value = item.read(this.inputStream);
                this.id = this.inputStream.readVarInt();
                return value;
            }
            return item.defaultValue;
        }

        void end() throws IOException {
            if (this.id != 0) {
                // empty if block
            }
        }
    }
}

