/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenUUID;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;

public class SkinDocumentNode
implements IDataSerializable.Immutable {
    public static final IDataCodec<SkinDocumentNode> CODEC = IDataCodec.COMPOUND_TAG.serializer(SkinDocumentNode::new);
    private OpenVector3f location = OpenVector3f.ZERO;
    private OpenVector3f rotation = OpenVector3f.ZERO;
    private OpenVector3f scale = OpenVector3f.ONE;
    private OpenVector3f pivot = OpenVector3f.ZERO;
    private OpenTransform3f transform = null;
    private SkinPartType type;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private String name;
    private SkinDocumentNode parent;
    private SkinDocumentListener listener;
    private boolean isEnabled = true;
    private boolean isMirror = false;
    private final String id;
    private final ArrayList<SkinDocumentNode> children = new ArrayList();
    private String cachedTypeName;

    public SkinDocumentNode(String name) {
        this(OpenUUID.randomUUIDString(), name);
    }

    public SkinDocumentNode(String id, String name) {
        this(id, name, SkinPartTypes.ADVANCED);
    }

    public SkinDocumentNode(String id, String name, SkinPartType type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public SkinDocumentNode(IDataSerializer serializer) {
        this.id = serializer.read(CodingKeys.UID);
        this.name = serializer.read(CodingKeys.NAME);
        this.type = serializer.read(CodingKeys.TYPE);
        this.skin = serializer.read(CodingKeys.SKIN);
        this.location = serializer.read(CodingKeys.LOCATION);
        this.rotation = serializer.read(CodingKeys.ROTATION);
        this.scale = serializer.read(CodingKeys.SCALE);
        this.pivot = serializer.read(CodingKeys.PIVOT);
        this.children.addAll((Collection<SkinDocumentNode>)serializer.read(CodingKeys.CHILDREN));
        this.isEnabled = serializer.read(CodingKeys.ENABLED);
        this.isMirror = serializer.read(CodingKeys.MIRROR);
        this.children.forEach(it -> {
            it.parent = this;
        });
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.UID, this.id);
        serializer.write(CodingKeys.NAME, this.name);
        serializer.write(CodingKeys.TYPE, this.type);
        serializer.write(CodingKeys.SKIN, this.skin);
        serializer.write(CodingKeys.LOCATION, this.location);
        serializer.write(CodingKeys.ROTATION, this.rotation);
        serializer.write(CodingKeys.SCALE, this.scale);
        serializer.write(CodingKeys.PIVOT, this.pivot);
        serializer.write(CodingKeys.CHILDREN, this.children);
        serializer.write(CodingKeys.ENABLED, this.isEnabled);
        serializer.write(CodingKeys.MIRROR, this.isMirror);
    }

    public void deserialize(IDataSerializer serializer) {
        Boolean newMirror;
        Boolean newEnabled;
        String newName;
        OpenVector3f newPivot;
        OpenVector3f newScale;
        OpenVector3f newRotation;
        OpenVector3f newLocation;
        SkinDescriptor newSkin = serializer.read(CodingKeys.INC_SKIN);
        if (newSkin != null) {
            this.skin = newSkin;
        }
        if ((newLocation = serializer.read(CodingKeys.INC_LOCATION)) != null) {
            this.location = newLocation;
            this.transform = null;
        }
        if ((newRotation = serializer.read(CodingKeys.INC_ROTATION)) != null) {
            this.rotation = newRotation;
            this.transform = null;
        }
        if ((newScale = serializer.read(CodingKeys.INC_SCALE)) != null) {
            this.scale = newScale;
            this.transform = null;
        }
        if ((newPivot = serializer.read(CodingKeys.INC_PIVOT)) != null) {
            this.pivot = newPivot;
            this.transform = null;
        }
        if ((newName = serializer.read(CodingKeys.INC_NAME)) != null) {
            this.name = newName;
        }
        if ((newEnabled = serializer.read(CodingKeys.INC_ENABLED)) != null) {
            this.isEnabled = newEnabled;
        }
        if ((newMirror = serializer.read(CodingKeys.INC_MIRROR)) != null) {
            this.isMirror = newMirror;
        }
    }

    public void applyChanges(CompoundNBT tag) {
        this.deserialize(new TagSerializer(tag));
        this.listener.documentDidUpdateNode(this, tag);
    }

    public void add(SkinDocumentNode node) {
        if (node.parent != null) {
            node.removeFromParent();
        }
        this.children.add(node);
        node.parent = this;
        node.setListener(this.listener);
        if (this.listener != null) {
            this.listener.documentDidInsertNode(this, node, -1);
        }
    }

    public void insertAtIndex(SkinDocumentNode node, int index) {
        if (node.parent != null) {
            node.removeFromParent();
        }
        this.children.add(index, node);
        node.parent = this;
        node.setListener(this.listener);
        if (this.listener != null) {
            this.listener.documentDidInsertNode(this, node, index);
        }
    }

    public void moveTo(SkinDocumentNode node, int toIndex) {
        int index = this.children.indexOf(node);
        if (index < 0 || index == toIndex) {
            return;
        }
        this.children.remove(index);
        this.children.add(OpenMath.clamp(toIndex, 0, this.children.size()), node);
        if (this.listener != null) {
            this.listener.documentDidMoveNode(this, node, toIndex);
        }
    }

    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        if (this.listener != null) {
            this.listener.documentDidRemoveNode(this);
        }
        this.parent.children.remove(this);
        this.parent = null;
        this.setListener(null);
    }

    public void setName(String value) {
        this.name = value;
        this.cachedTypeName = null;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_NAME, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public String name() {
        if (this.name != null) {
            return this.name;
        }
        if (this.cachedTypeName != null) {
            return this.cachedTypeName;
        }
        IFormattableTextComponent lhs = TranslateUtils.title("documentType.armourers_workshop.node.root", new Object[0]);
        IFormattableTextComponent rhs = TranslateUtils.title("documentType.armourers_workshop.node." + this.id, new Object[0]);
        if (this.type != SkinPartTypes.ADVANCED) {
            rhs = TranslateUtils.Name.of("documentType.armourers_workshop.node", this.type);
        }
        this.cachedTypeName = TranslateUtils.title("documentType.armourers_workshop.node", lhs, rhs).getString();
        return this.cachedTypeName;
    }

    public void setType(SkinPartType type) {
        this.type = type;
        this.cachedTypeName = null;
    }

    public SkinPartType type() {
        return this.type;
    }

    public void setSkin(SkinDescriptor value) {
        this.skin = value;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_SKIN, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public SkinDescriptor skin() {
        return this.skin;
    }

    public void setLocation(OpenVector3f value) {
        this.location = value;
        this.transform = null;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_LOCATION, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public OpenVector3f location() {
        return this.location;
    }

    public void setRotation(OpenVector3f value) {
        this.rotation = value;
        this.transform = null;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_ROTATION, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public OpenVector3f rotation() {
        return this.rotation;
    }

    public void setScale(OpenVector3f value) {
        this.scale = value;
        this.transform = null;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_SCALE, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public OpenVector3f scale() {
        return this.scale;
    }

    public void setPivot(OpenVector3f value) {
        this.pivot = value;
        this.transform = null;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_PIVOT, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public OpenVector3f pivot() {
        return this.pivot;
    }

    public OpenTransform3f transform() {
        if (this.transform != null) {
            return this.transform;
        }
        OpenVector3f translate = this.location;
        OpenVector3f pivot = this.pivot;
        if (!translate.equals(OpenVector3f.ZERO)) {
            translate = new OpenVector3f(-translate.x(), -translate.y(), translate.z());
        }
        if (!pivot.equals(OpenVector3f.ZERO)) {
            pivot = new OpenVector3f(-pivot.x(), -pivot.y(), pivot.z());
        }
        OpenVector3f scale = this.scale;
        if (this.isMirror) {
            scale = scale.scaling(-1.0f, 1.0f, 1.0f);
        }
        this.transform = OpenTransform3f.create(translate, this.rotation, scale, pivot, OpenVector3f.ZERO);
        return this.transform;
    }

    public String id() {
        return this.id;
    }

    public void setEnabled(boolean value) {
        this.isEnabled = value;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_ENABLED, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setMirror(boolean value) {
        this.isMirror = value;
        this.transform = null;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_MIRROR, value);
            this.listener.documentDidUpdateNode(this, builder.tag());
        }
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public boolean isLocked() {
        return this.name == null;
    }

    public boolean isStatic() {
        return this.type == SkinPartTypes.ADVANCED_STATIC;
    }

    public boolean isFloat() {
        return this.type == SkinPartTypes.ADVANCED_FLOAT;
    }

    public boolean isLocator() {
        return this.type == SkinPartTypes.ADVANCED_LOCATOR;
    }

    public boolean isBasic() {
        return this.type != SkinPartTypes.ADVANCED && this.type != SkinPartTypes.ADVANCED_STATIC && this.type != SkinPartTypes.ADVANCED_FLOAT && this.type != SkinPartTypes.ADVANCED_LOCATOR;
    }

    public SkinDocumentNode parent() {
        return this.parent;
    }

    public ArrayList<SkinDocumentNode> children() {
        return this.children;
    }

    protected void setListener(SkinDocumentListener listener) {
        this.listener = listener;
        this.children.forEach(it -> it.setListener(listener));
    }

    protected SkinDocumentListener listener() {
        return this.listener;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<String> UID = IDataSerializerKey.create("UID", IDataCodec.STRING, "");
        public static final IDataSerializerKey<String> NAME = IDataSerializerKey.create("Name", IDataCodec.STRING, null);
        public static final IDataSerializerKey<SkinPartType> TYPE = IDataSerializerKey.create("Type", SkinPartTypes.CODEC, SkinPartTypes.ADVANCED);
        public static final IDataSerializerKey<SkinDescriptor> SKIN = IDataSerializerKey.create("Skin", SkinDescriptor.CODEC, SkinDescriptor.EMPTY);
        public static final IDataSerializerKey<OpenVector3f> LOCATION = IDataSerializerKey.create("Location", OpenVector3f.CODEC, OpenVector3f.ZERO);
        public static final IDataSerializerKey<OpenVector3f> ROTATION = IDataSerializerKey.create("Rotation", OpenVector3f.CODEC, OpenVector3f.ZERO);
        public static final IDataSerializerKey<OpenVector3f> SCALE = IDataSerializerKey.create("Scale", OpenVector3f.CODEC, OpenVector3f.ONE);
        public static final IDataSerializerKey<OpenVector3f> PIVOT = IDataSerializerKey.create("Pivot", OpenVector3f.CODEC, OpenVector3f.ZERO);
        public static final IDataSerializerKey<List<SkinDocumentNode>> CHILDREN = IDataSerializerKey.create("Children", CODEC.listOf(), Collections.emptyList());
        public static final IDataSerializerKey<Boolean> ENABLED = IDataSerializerKey.create("Enabled", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> MIRROR = IDataSerializerKey.create("Mirror", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<String> INC_NAME = IDataSerializerKey.create("Name", IDataCodec.STRING, null);
        public static final IDataSerializerKey<SkinDescriptor> INC_SKIN = IDataSerializerKey.create("Skin", SkinDescriptor.CODEC, null);
        public static final IDataSerializerKey<OpenVector3f> INC_LOCATION = IDataSerializerKey.create("Location", OpenVector3f.CODEC, null);
        public static final IDataSerializerKey<OpenVector3f> INC_ROTATION = IDataSerializerKey.create("Rotation", OpenVector3f.CODEC, null);
        public static final IDataSerializerKey<OpenVector3f> INC_SCALE = IDataSerializerKey.create("Scale", OpenVector3f.CODEC, null);
        public static final IDataSerializerKey<OpenVector3f> INC_PIVOT = IDataSerializerKey.create("Pivot", OpenVector3f.CODEC, null);
        public static final IDataSerializerKey<Boolean> INC_ENABLED = IDataSerializerKey.create("Enabled", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<Boolean> INC_MIRROR = IDataSerializerKey.create("Mirror", IDataCodec.BOOL, null);

        private CodingKeys() {
        }
    }
}

