/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.exporter;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometrySet;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFaceCuller;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.serializer.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.core.skin.serializer.exporter.SkinExporter;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModLog;

public class SkinExporterWavefrontObj
implements SkinExporter {
    private static final String CRLF = "\n";
    private int faceIndex;
    private HashMap<Integer, Integer> colors;

    @Override
    public Collection<String> extensions() {
        return Collections.singleton("obj");
    }

    @Override
    public void exportSkin(Skin skin, File filePath, String filename, float scale) throws Exception {
        this.colors = new HashMap();
        this.faceIndex = 0;
        File outputFile = new File(filePath, filename + ".obj");
        FileOutputStream fos = new FileOutputStream(outputFile);
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        ArrayList<Task> tasks = new ArrayList<Task>();
        int colorIndex = 0;
        int totalFaces = 0;
        for (SkinPart skinPart : skin.parts()) {
            Task task = new Task(skin, skinPart);
            for (SkinCubeFace face : task.cubeFaces) {
                int color2;
                if (!face.isVisible() || this.colors.containsKey(color2 = face.color().argb() | 0xFF000000)) continue;
                this.colors.put(color2, colorIndex++);
            }
            tasks.add(task);
            totalFaces += task.cubeFaces.size();
        }
        ModLog.debug("create task with {} total faces.", totalFaces);
        int textureTotalSize = this.colors.size();
        int textureSize = 0;
        while (textureSize * textureSize < textureTotalSize * 4) {
            textureSize = this.getNextPowerOf2(textureSize + 1);
        }
        ModLog.debug("create {}x{} texture of {}", textureSize, textureSize, textureTotalSize);
        TextureBuilder textureBuilder = new TextureBuilder(textureSize, textureSize);
        this.colors.forEach((color, index) -> textureBuilder.setColor((int)index, (int)color));
        os.write("# WavefrontObj\n");
        os.write("# This file was exported from the Minecraft mod Armourer's Workshop\n");
        os.write("mtllib " + filename + ".mtl" + CRLF);
        int partIndex = 0;
        for (Task task : tasks) {
            OpenPoseStack poseStack = new OpenPoseStack();
            SkinPart part = task.skinPart;
            SkinPartTransform transform = new SkinPartTransform(part, OpenTransform3f.IDENTITY);
            poseStack.scale(scale, scale, scale);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.rotate(OpenVector3f.YP.rotationDegrees(90.0f));
            OpenVector3i pos = part.type().renderOffset();
            poseStack.translate(pos.x(), pos.y(), pos.z());
            transform.apply(poseStack);
            this.exportPart(poseStack, task.cubeFaces, part, task.skin, os, textureBuilder, partIndex++);
        }
        os.flush();
        fos.flush();
        ImageIO.write((RenderedImage)textureBuilder.build(), "png", new File(filePath, filename + ".png"));
        this.createMtlFile(filePath, filename);
    }

    private void exportPart(OpenPoseStack poseStack, ArrayList<SkinCubeFace> allFaces, SkinPart skinPart, Skin skin, OutputStreamWriter os, TextureBuilder texture, int partIndex) throws IOException {
        HashMap<SkinGeometryType, ArrayList> faces = new HashMap<SkinGeometryType, ArrayList>();
        for (SkinCubeFace face : allFaces) {
            if (!face.isVisible()) continue;
            faces.computeIfAbsent(face.type(), k -> new ArrayList()).add(face);
        }
        String[] layerNames = new String[]{"opaque", "glowing", "transparent", "transparent-glowing"};
        for (int i = 0; i < SkinGeometryTypes.getTotalCubes(); ++i) {
            ArrayList faces1 = (ArrayList)faces.get(SkinGeometryTypes.byId(i));
            if (faces1 == null || faces1.isEmpty()) continue;
            this.exportLayer(poseStack, faces1, skinPart, skin, os, texture, layerNames[i], partIndex);
        }
    }

    private void exportLayer(OpenPoseStack poseStack, ArrayList<SkinCubeFace> faces, SkinPart skinPart, Skin skin, OutputStreamWriter os, TextureBuilder texture, String layer, int partIndex) throws IOException {
        ModLog.debug("export {} layer of {}:{}, faces: {}", layer, partIndex, skinPart.type(), faces.size());
        os.write("o " + partIndex + "-" + skinPart.type().registryName().path() + "-" + layer + CRLF);
        os.write("usemtl basetexture\n");
        os.write("s 1\n");
        os.flush();
        for (SkinCubeFace face : faces) {
            OpenRectangle3f shape = face.boundingBox();
            float x = shape.x();
            float y = shape.y();
            float z = shape.z();
            float w = shape.width();
            float h = shape.height();
            float d = shape.depth();
            float[][] vertexes = SkinCubeFace.getBaseVertices(face.direction());
            for (int i = 0; i < 4; ++i) {
                this.writeVert(poseStack, os, x + vertexes[i][0] * w, y + vertexes[i][1] * h, z + vertexes[i][2] * d);
            }
        }
        double scale = 1.0 / (double)texture.width;
        for (SkinCubeFace face : faces) {
            int index = this.colors.getOrDefault(face.color().argb() | 0xFF000000, 0);
            double ix = (double)texture.x(index) + 0.5;
            double iy = (double)texture.y(index) + 0.5;
            this.writeTexture(os, (ix + 1.0) * scale, iy * scale);
            this.writeTexture(os, (ix + 1.0) * scale, (iy + 1.0) * scale);
            this.writeTexture(os, ix * scale, (iy + 1.0) * scale);
            this.writeTexture(os, ix * scale, iy * scale);
        }
        for (SkinCubeFace face : faces) {
            float[][] vertexes = SkinCubeFace.getBaseVertices(face.direction());
            this.writeNormal(poseStack, os, vertexes[4][0], vertexes[4][1], vertexes[4][2]);
        }
        for (SkinCubeFace face : faces) {
            os.write("f");
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 1, 4 * this.faceIndex + 1, this.faceIndex + 1));
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 2, 4 * this.faceIndex + 2, this.faceIndex + 1));
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 3, 4 * this.faceIndex + 3, this.faceIndex + 1));
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 4, 4 * this.faceIndex + 4, this.faceIndex + 1));
            os.write(CRLF);
            ++this.faceIndex;
        }
    }

    private void writeVert(OpenPoseStack poseStack, OutputStreamWriter os, float x, float y, float z) throws IOException {
        OpenVector4f v = new OpenVector4f(x, y, z, 1.0f);
        v.transform(poseStack.last().pose());
        os.write(String.format("v %s %s %s", this.f2s(v.x()), this.f2s(v.y()), this.f2s(v.z())) + CRLF);
    }

    private void writeNormal(OpenPoseStack poseStack, OutputStreamWriter os, float x, float y, float z) throws IOException {
        OpenVector3f v = new OpenVector3f(x, y, z);
        v.transform(poseStack.last().normal());
        os.write(String.format("vn %s %s %s", this.f2s(v.x()), this.f2s(v.y()), this.f2s(v.z())) + CRLF);
    }

    private void writeTexture(OutputStreamWriter os, double x, double y) throws IOException {
        os.write(String.format("vt %s %s", this.f2s(x), this.f2s(y)) + CRLF);
    }

    private void createMtlFile(File filePath, String filename) throws IOException {
        File outputFile = new File(filePath, filename + ".mtl");
        FileOutputStream fos = new FileOutputStream(outputFile);
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        os.write("newmtl basetexture\n");
        os.write("Ns 96.078431\n");
        os.write("Ka 1.000000 1.000000 1.000000\n");
        os.write("Kd 0.800000 0.800000 0.800000\n");
        os.write("Ks 0.500000 0.500000 0.500000\n");
        os.write("Ke 0.000000 0.000000 0.000000\n");
        os.write("Ni 1.000000\n");
        os.write("d 1.000000\n");
        os.write("illum 0\n");
        os.write("map_Kd " + filename + ".png" + CRLF);
        os.flush();
    }

    private int getNextPowerOf2(int value) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(value - 1));
    }

    private String f2s(float value) {
        return SkinExportManager.FLOAT_FORMAT.format(value);
    }

    private String f2s(double value) {
        return SkinExportManager.DOUBLE_FORMAT.format(value);
    }

    private static class Task {
        private final Skin skin;
        private final SkinPart skinPart;
        private final ArrayList<SkinCubeFace> cubeFaces;

        public Task(Skin skin, SkinPart skinPart) {
            ISkinGeometrySet geometries = skinPart.geometries();
            OpenRectangle3i bounds = new OpenRectangle3i(((SkinGeometrySet)geometries).shape().bounds());
            this.skin = skin;
            this.skinPart = skinPart;
            this.cubeFaces = Collections.collect(SkinCubeFaceCuller.cullFaces(geometries, bounds), SkinCubeFace.class);
        }
    }

    private static class TextureBuilder {
        private final int width;
        private final int height;
        private final BufferedImage image;

        public TextureBuilder(int width, int height) {
            this.width = width;
            this.height = height;
            this.image = new BufferedImage(width, height, 2);
        }

        public void setColor(int index, int color) {
            int ix = this.x(index);
            int iy = this.height - 1 - this.y(index);
            this.image.setRGB(ix, iy, color);
            this.image.setRGB(ix + 1, iy, color);
            this.image.setRGB(ix, iy - 1, color);
            this.image.setRGB(ix + 1, iy - 1, color);
        }

        public int x(int index) {
            return index % (this.width / 2) * 2;
        }

        public int y(int index) {
            return index / (this.width / 2) * 2;
        }

        public BufferedImage build() {
            return this.image;
        }
    }
}

