/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v12;

import java.io.IOException;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.geometry.collection.SkinGeometrySetV1;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.init.ModLog;

public final class SkinPartSerializerV12 {
    public String getTypeNameByLegacyId(int legacyId) {
        String string;
        switch (legacyId) {
            case 0: {
                string = "armourers:head.base";
                break;
            }
            case 1: {
                string = "armourers:chest.base";
                break;
            }
            case 2: {
                string = "armourers:chest.leftArm";
                break;
            }
            case 3: {
                string = "armourers:chest.rightArm";
                break;
            }
            case 4: {
                string = "armourers:legs.leftLeg";
                break;
            }
            case 5: {
                string = "armourers:legs.rightLeg";
                break;
            }
            case 6: {
                string = "armourers:skirt.base";
                break;
            }
            case 7: {
                string = "armourers:feet.leftFoot";
                break;
            }
            case 8: {
                string = "armourers:feet.rightFoot";
                break;
            }
            case 9: {
                string = "armourers:sword.base";
                break;
            }
            case 10: {
                string = "armourers:bow.base";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public SkinPart loadSkinPart(IInputStream stream, int version) throws IOException, InvalidCubeTypeException {
        String regName;
        SkinPartType partType = null;
        ArrayList<SkinMarker> markerBlocks = null;
        if (version < 6) {
            regName = this.getTypeNameByLegacyId(stream.readByte());
            partType = SkinPartTypes.byName(regName);
            if (partType == null) {
                ModLog.error("Skin part was null", new Object[0]);
                throw new IOException("Skin part was null");
            }
        } else {
            regName = null;
            regName = version > 12 ? stream.readString() : stream.readString();
            if (regName.equals("armourers:skirt.base")) {
                regName = "armourers:legs.skirt";
            }
            if (regName.equals("armourers:bow.base")) {
                regName = "armourers:bow.frame1";
            }
            if (regName.equals("armourers:arrow.base")) {
                regName = "armourers:bow.arrow";
            }
            if ((partType = SkinPartTypes.byName(regName)) == null) {
                ModLog.error("Skin part was null - reg name: " + regName + " version: " + version, new Object[0]);
                throw new IOException("Skin part was null - reg name: " + regName + " version: " + version);
            }
        }
        SkinGeometrySetV1 geometries = SkinGeometrySetV1.readFromStream(stream, version, partType);
        markerBlocks = new ArrayList<SkinMarker>();
        if (version > 8) {
            int markerCount = stream.readInt();
            for (int i = 0; i < markerCount; ++i) {
                markerBlocks.add(new SkinMarker(stream));
            }
        }
        SkinPart.Builder builder = new SkinPart.Builder(partType);
        builder.markers(markerBlocks);
        builder.geometries(geometries);
        return builder.build();
    }

    public void saveSkinPart(SkinPart skinPart, IOutputStream stream) throws IOException {
        stream.writeString(skinPart.type().registryName().toString());
        SkinGeometrySetV1.writeToStream(skinPart.geometries(), stream);
        stream.writeInt(skinPart.markers().size());
        for (SkinMarker marker : skinPart.markers()) {
            marker.writeToStream(stream);
        }
    }
}

