/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryOptions;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryVertex;
import moe.plushie.armourers_workshop.core.skin.geometry.mesh.SkinMesh;
import moe.plushie.armourers_workshop.core.skin.geometry.mesh.SkinMeshFace;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySlice;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTextureData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializer;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;

public class ChunkGeometrySerializerV3
extends ChunkGeometrySerializer {
    @Override
    public int stride(SkinGeometryType geometryType, int options, ChunkPaletteData palette) {
        return 128 + options;
    }

    @Override
    public ChunkGeometrySerializer.Encoder<?> encoder(SkinGeometryType geometryType) {
        return new Encoder();
    }

    @Override
    public ChunkGeometrySerializer.Decoder<?> decoder(SkinGeometryType geometryType, ChunkGeometrySlice slice) {
        return new Decoder(geometryType, slice);
    }

    protected static class Encoder
    implements ChunkGeometrySerializer.Encoder<SkinMesh> {
        private static final int HEADER_SIZE = 128;
        private static final int INDEX_STRIDE = 4;
        private static final int VERTEX_STRIDE = 32;
        private SkinGeometryOptions options = SkinGeometryOptions.EMPTY;
        private OpenTransform3f transform = OpenTransform3f.IDENTITY;
        private SkinTexturePos texturePos;
        private final List<Integer> indices = new ArrayList<Integer>();
        private final List<SkinGeometryVertex> vertices = new ArrayList<SkinGeometryVertex>();
        private final byte[] reserved = new byte[128];

        protected Encoder() {
        }

        @Override
        public int begin(SkinMesh mesh) {
            this.indices.clear();
            this.vertices.clear();
            this.options = mesh.options();
            this.transform = mesh.transform();
            this.texturePos = mesh.texturePos();
            LinkedHashMap<Integer, ArrayList> groupedVertices = new LinkedHashMap<Integer, ArrayList>();
            for (SkinMeshFace skinMeshFace : mesh.faces()) {
                Iterable faceVertices = skinMeshFace.vertices();
                groupedVertices.computeIfAbsent(faceVertices.size(), k -> new ArrayList()).addAll(faceVertices);
            }
            for (Map.Entry entry : groupedVertices.entrySet()) {
                int faceVertexCount = (Integer)entry.getKey();
                int type = faceVertexCount & 0xFF;
                int length = ((ArrayList)entry.getValue()).size();
                this.indices.add(type);
                this.indices.add(length);
                this.vertices.addAll((Collection)entry.getValue());
            }
            return this.vertices.size() * 32 + this.indices.size() * 4;
        }

        @Override
        public void end(ChunkPaletteData palette, ChunkDataOutputStream stream) throws IOException {
            stream.writeInt(0);
            stream.writeTransformf(this.transform);
            stream.writeInt(this.vertices.size());
            stream.writeInt(this.indices.size());
            stream.writeLong(this.options.asLong());
            stream.write(this.reserved, 0, 44);
            for (SkinGeometryVertex vertex : this.vertices) {
                stream.writeVector3f(vertex.position());
                stream.writeVector3f(vertex.normal());
                stream.writeVariable(palette.writeTexture(vertex.textureCoords(), this.texturePos.provider()));
            }
            for (Integer vertexId : this.indices) {
                stream.writeInt(vertexId);
            }
            this.vertices.clear();
            this.indices.clear();
            this.texturePos = null;
        }
    }

    protected static class Decoder
    extends SkinMesh
    implements ChunkGeometrySerializer.Decoder<SkinMesh> {
        private final SkinGeometryType type;
        private final ChunkGeometrySlice slice;
        private final ChunkPaletteData palette;
        private final ArrayList<SkinMeshFace> faces = new ArrayList();
        private final ArrayList<SkinGeometryVertex> vertices = new ArrayList();
        private SkinTextureData textureProvider;

        public Decoder(SkinGeometryType type, ChunkGeometrySlice slice) {
            this.type = type;
            this.palette = slice.palette();
            this.slice = slice;
        }

        public static int calcStride(int usedBytes, int size) {
            return 128 + 32 * size;
        }

        @Override
        public SkinMesh begin() {
            return this;
        }

        @Override
        public SkinGeometryType type() {
            return this.type;
        }

        @Override
        public SkinGeometryOptions options() {
            if (this.slice.once(4)) {
                this.options = new SkinGeometryOptions(this.slice.getTextureOptions(76));
            }
            return this.options;
        }

        @Override
        public OpenTransform3f transform() {
            if (this.slice.once(0)) {
                this.transform = this.slice.getTransform(4);
            }
            return this.transform;
        }

        @Override
        public SkinTexturePos texturePos() {
            if (this.slice.once(1)) {
                this.vertices();
                if (this.textureProvider != null) {
                    this.texturePos = new SkinTexturePos(0.0f, 0.0f, 0.0f, 0.0f, this.textureProvider);
                }
            }
            return this.texturePos;
        }

        @Override
        public List<SkinMeshFace> faces() {
            if (this.slice.once(2)) {
                this.parseFaces();
            }
            return this.faces;
        }

        public List<SkinGeometryVertex> vertices() {
            if (this.slice.once(3)) {
                this.parseVertices();
            }
            return this.vertices;
        }

        protected void parseFaces() {
            this.faces.clear();
            int vertexCount = this.slice.getInt(68);
            int indexCount = this.slice.getInt(72);
            int usedBytes = this.palette.textureIndexBytes();
            int offset = Decoder.calcStride(usedBytes, vertexCount);
            SkinGeometryOptions options = this.options();
            List<SkinGeometryVertex> vertices = this.vertices();
            OpenTransform3f transform = this.transform();
            SkinTexturePos texturePos = this.texturePos();
            int cursor = 0;
            for (int i = 0; i < indexCount; i += 2) {
                int type = this.slice.getInt(offset + i * 4);
                int length = this.slice.getInt(offset + i * 4 + 4);
                int faceVertexCount = type & 0xFF;
                for (int j = 0; j < length; j += faceVertexCount) {
                    this.faces.add(this.parseFace(this.faces.size(), cursor + j, faceVertexCount, options, transform, texturePos, vertices));
                }
                cursor += length;
            }
        }

        protected void parseVertices() {
            this.vertices.clear();
            int usedBytes = this.palette.textureIndexBytes();
            int vertexCount = this.slice.getInt(68);
            for (int i = 0; i < vertexCount; ++i) {
                this.vertices.add(this.parseVertex(i, usedBytes));
            }
        }

        protected SkinMeshFace parseFace(int faceId, int offset, int vertexCount, SkinGeometryOptions options, OpenTransform3f transform, SkinTexturePos texturePos, List<SkinGeometryVertex> vertices) {
            ArrayList<SkinGeometryVertex> faceVertices = new ArrayList<SkinGeometryVertex>(vertexCount);
            for (int i = 0; i < vertexCount; ++i) {
                faceVertices.add(vertices.get(offset + i));
            }
            return new SkinMeshFace(faceId, this.type, options, transform, texturePos, faceVertices);
        }

        protected SkinGeometryVertex parseVertex(int i, int usedBytes) {
            int offset = Decoder.calcStride(usedBytes, i);
            OpenVector3f position = this.slice.getVector3f(offset);
            OpenVector3f normal = this.slice.getVector3f(offset + 12);
            OpenVector2f textureCoords = this.slice.getTexturePos(offset + 24);
            textureCoords = this.parseTextureCoords(textureCoords);
            return new SkinGeometryVertex(i, position, normal, textureCoords);
        }

        protected OpenVector2f parseTextureCoords(OpenVector2f uv) {
            ChunkTextureData.TextureRef ref = this.palette.readTexture(uv);
            if (ref != null) {
                this.textureProvider = ref.provider();
                return ref.uv();
            }
            return OpenVector2f.ZERO;
        }
    }
}

