/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public final class TranslateUtils {
    private static final TextFormatter FORMATTER = new TextFormatter();

    public static IFormattableTextComponent formatted(String content) {
        return TranslatableProvider.literal(ITextComponent.class, FORMATTER.getFormattedString(content));
    }

    public static IFormattableTextComponent title(String key, Object ... args) {
        return TranslatableProvider.translatable(ITextComponent.class, FORMATTER, key, args);
    }

    public static IFormattableTextComponent subtitle(String key, Object ... args) {
        return TranslateUtils.title(key, args).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
    }

    public static ArrayList<ITextComponent> subtitles(String key) {
        ArrayList<ITextComponent> results = new ArrayList<ITextComponent>();
        IFormattableTextComponent value1 = TranslateUtils.subtitle(key, new Object[0]);
        String value = value1.getString();
        if (key.equals(value)) {
            return results;
        }
        Style style = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
        for (String line : FORMATTER.getFormattedString(value).split("(\\r?\\n)|(%n)")) {
            results.add((ITextComponent)TranslatableProvider.literal(ITextComponent.class, line).func_230530_a_(style));
        }
        return results;
    }

    public static class TextFormatter {
        public String getEmbeddedStyle(String value) {
            int i = value.length();
            StringBuilder results = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                char c0 = value.charAt(j);
                if (c0 != '\u00a7') continue;
                if (j + 1 >= i) break;
                char c1 = value.charAt(j + 1);
                results.append(c0);
                results.append(c1);
                ++j;
            }
            return results.toString();
        }

        public String getFormattedString(String value) {
            value = value.replace("\n", System.lineSeparator());
            value = value.replace("%n", System.lineSeparator());
            return value;
        }
    }

    public static class Name {
        public static IFormattableTextComponent of(ItemOverrideType overrideType) {
            return TranslateUtils.title("itemOverrideType.armourers_workshop." + overrideType.serializedName(), new Object[0]);
        }

        public static IFormattableTextComponent of(SkinDocumentType documentType) {
            IFormattableTextComponent lhs = TranslateUtils.title("documentType.armourers_workshop.category." + documentType.category(), new Object[0]);
            IFormattableTextComponent rhs = Name.of(documentType.skinType());
            return TranslateUtils.title("documentType.armourers_workshop.category", lhs, rhs);
        }

        public static IFormattableTextComponent of(SkinType skinType) {
            if (skinType == SkinTypes.UNKNOWN) {
                return TranslateUtils.title("skinType.armourers_workshop.all", new Object[0]);
            }
            String path = skinType.registryName().path();
            return TranslateUtils.title("skinType.armourers_workshop." + path, new Object[0]);
        }

        public static IFormattableTextComponent of(SkinPartType skinPartType) {
            return Name.of("skinPartType.armourers_workshop", skinPartType);
        }

        public static IFormattableTextComponent of(String prefix, SkinPartType skinPartType) {
            String path = skinPartType.registryName().path();
            String key = prefix + "." + path;
            IFormattableTextComponent text = TranslateUtils.title(key, new Object[0]);
            if (!text.getString().equals(key)) {
                return text;
            }
            ModLog.debug("missing translation text for key {}", key);
            return TranslateUtils.title(prefix + ".part.base", new Object[0]);
        }

        public static IFormattableTextComponent of(SkinPaintType paintType) {
            String path = paintType.registryName().path();
            return TranslateUtils.title("paintType.armourers_workshop." + path, new Object[0]);
        }
    }
}

