/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ModMenuOptions {
    private static final ModMenuOptions INSTANCE = new ModMenuOptions();
    private final File contentPath;
    private final CompoundNBT values = new CompoundNBT();

    private ModMenuOptions() {
        this.contentPath = new File(EnvironmentManager.getRootDirectory(), "options.dat");
        if (this.contentPath.exists()) {
            this.load();
        }
    }

    public static ModMenuOptions getInstance() {
        return INSTANCE;
    }

    public void putString(String key, String value) {
        this.values.func_74778_a(key, value);
        this.setChanged();
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        return OptionalAPI.getOptionalString(this.values, key).orElse(defaultValue);
    }

    public void putInt(String key, int value) {
        this.values.func_74768_a(key, value);
        this.setChanged();
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return OptionalAPI.getOptionalInt(this.values, key).orElse(defaultValue);
    }

    public void putBoolean(String key, boolean value) {
        this.values.func_74757_a(key, value);
        this.setChanged();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return OptionalAPI.getOptionalBoolean(this.values, key).orElse(defaultValue);
    }

    public void putTag(String key, CompoundNBT tag) {
        this.values.func_218657_a(key, (INBT)tag);
        this.setChanged();
    }

    public CompoundNBT getTag(String key) {
        return OptionalAPI.getOptionalCompound(this.values, key).orElse(null);
    }

    private void load() {
        try (FileInputStream inputStream = new FileInputStream(this.contentPath);){
            CompoundNBT tag = TagSerializer.parse(inputStream);
            this.values.func_197643_a(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save() {
        try (FileOutputStream outputStream = new FileOutputStream(this.contentPath);){
            TagSerializer.writeToStream(this.values, (OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setChanged() {
        EnvironmentExecutor.runOnBackground(() -> this::save);
    }
}

