/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import moe.plushie.armourers_workshop.api.common.IArgumentSerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.command.ColorParser;
import net.minecraft.command.CommandSource;

public class ColorArgumentType
implements ArgumentType<SkinPaintColor> {
    private static final Collection<String> EXAMPLES = Collections.newList("[paintType:]#RRGGBB", "[paintType:]R,G,B");

    public static SkinPaintColor getColor(CommandContext<CommandSource> context, String name) {
        return (SkinPaintColor)context.getArgument(name, SkinPaintColor.class);
    }

    public SkinPaintColor parse(StringReader reader) throws CommandSyntaxException {
        ColorParser parser = new ColorParser(reader).parse();
        return parser.paintColor();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ColorParser parser = new ColorParser(stringReader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return parser.fillSuggestions(builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Serializer
    implements IArgumentSerializer<ColorArgumentType> {
        @Override
        public void serializeToNetwork(ColorArgumentType argument, IFriendlyByteBuf buffer) {
        }

        @Override
        public ColorArgumentType deserializeFromNetwork(IFriendlyByteBuf buffer) {
            return new ColorArgumentType();
        }

        @Override
        public void serializeToJson(ColorArgumentType argument, JsonObject json) {
        }
    }
}

