/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Wrapper;
import moe.plushie.armourers_workshop.core.utils.OpenDistributionType;
import moe.plushie.armourers_workshop.init.environment.EnvironmentPlatformType;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.forge.EnvironmentManagerImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnvironmentManager {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModVersion(String modId) {
        return EnvironmentManagerImpl.getModVersion(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvironmentPlatformType getPlatformType() {
        return EnvironmentManagerImpl.getPlatformType();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvironmentType getEnvironmentType() {
        return EnvironmentManagerImpl.getEnvironmentType();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static File getRootDirectory() {
        return EnvironmentManagerImpl.getRootDirectory();
    }

    public static File getSkinLibraryDirectory() {
        return new File(EnvironmentManager.getRootDirectory(), "skin-library");
    }

    public static File getSkinCacheDirectory() {
        return new File(EnvironmentManager.getRootDirectory(), "skin-cache");
    }

    public static File getSkinDatabaseDirectory() {
        return EnvironmentManager.getServer().func_240776_a_(new FolderName("skin-database")).toFile();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getServer() {
        return EnvironmentManagerImpl.getServer();
    }

    public static OpenDistributionType getDistributionType(MinecraftServer server) {
        if (server == null) {
            return OpenDistributionType.CLIENT;
        }
        if (server.func_71262_S()) {
            return OpenDistributionType.DEDICATED_SERVER;
        }
        return OpenDistributionType.INTEGRATED_SERVER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Minecraft getClient() {
        return Minecraft.func_71410_x();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PlayerEntity getPlayer() {
        return EnvironmentManager.getClient().field_71439_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IResourceManager getResourceManager() {
        return Wrapper.asResourceManager(EnvironmentManager.getClient().func_195551_G());
    }

    public static boolean isDedicatedServer() {
        return EnvironmentManager.getEnvironmentType() == EnvironmentType.SERVER;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopment() {
        return EnvironmentManagerImpl.isDevelopment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isInstalled(String modId) {
        return EnvironmentManagerImpl.isInstalled(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IConfigSpec getClientConfigSpec() {
        return EnvironmentManagerImpl.getClientConfigSpec();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IConfigSpec getCommonConfigSpec() {
        return EnvironmentManagerImpl.getCommonConfigSpec();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static AbstractRegistryManager getRegistryManager() {
        return EnvironmentManagerImpl.getRegistryManager();
    }
}

