/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.library.data.impl.ReportType;

public class Report {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private final String userId;
    private final String skinId;
    private final ReportType reportType;
    private final String message;
    private final Date date;

    public Report(IODataObject object) {
        this.userId = object.get("userId").stringValue();
        this.skinId = object.get("reportSkinId").stringValue();
        this.reportType = ReportType.byName(object.get("reportType").stringValue());
        this.message = object.get("reportMessage").stringValue();
        this.date = this.toDate(object.get("date_created").stringValue());
    }

    private Date toDate(String value) {
        try {
            return SDF.parse(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String userId() {
        return this.userId;
    }

    public String skinId() {
        return this.skinId;
    }

    public ReportType reportType() {
        return this.reportType;
    }

    public String message() {
        return this.message;
    }

    public Date date() {
        return this.date;
    }

    public String toString() {
        return "SkinReport[userId=" + this.userId + ", skinId=" + this.skinId + ", reportType=" + (Object)((Object)this.reportType) + ", message=" + this.message + ", date=" + this.date + "]";
    }
}

