/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGRect;
import com.google.common.base.Objects;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;

public class ClipContextImpl {
    private static final CGRect EMPTY = new CGRect(-4000000.0f, -4000000.0f, 8000000.0f, 8000000.0f);
    private static final ClipContextImpl INSTANCE = new ClipContextImpl();
    private final Stack<CGRect> clipBoxes = new Stack();
    private final ScissorRenderer scissorRenderer = new ScissorRenderer();
    private final OffscreenRenderer offscreenRenderer = new OffscreenRenderer();

    public static ClipContextImpl getInstance() {
        return INSTANCE;
    }

    public void addClip(Rectangle rect) {
        CGRect newClipBox = rect.rect;
        if (!this.clipBoxes.isEmpty()) {
            newClipBox = this.clipBoxes.peek().intersection(newClipBox);
        }
        this.clipBoxes.push(newClipBox);
        this.scissorRenderer.render(newClipBox);
        this.offscreenRenderer.push(rect.offscreenPasses());
    }

    public void removeClip() {
        this.offscreenRenderer.pop();
        if (!this.clipBoxes.isEmpty()) {
            this.clipBoxes.pop();
            this.scissorRenderer.render(this.lastClipBox());
        }
    }

    public CGRect boundingBoxOfClipPath() {
        if (this.scissorRenderer.clipBox != null) {
            return this.scissorRenderer.clipBox;
        }
        return EMPTY;
    }

    private CGRect lastClipBox() {
        if (!this.clipBoxes.isEmpty()) {
            return this.clipBoxes.peek();
        }
        return null;
    }

    public static class ScissorRenderer {
        private CGRect clipBox;
        private final Window window = EnvironmentManager.getClient().m_91268_();

        public void render(@Nullable CGRect rect) {
            if (Objects.equal((Object)this.clipBox, (Object)rect)) {
                return;
            }
            this.clipBox = rect;
            if (rect != null) {
                double scale = this.window.m_85449_();
                int x = (int)((double)rect.x() * scale);
                int y = (int)((double)this.window.m_85442_() - (double)rect.maxY() * scale);
                int width = (int)((double)rect.width() * scale);
                int height = (int)((double)rect.height() * scale);
                RenderSystem.m_69488_((int)x, (int)y, (int)width, (int)height);
            } else {
                RenderSystem.m_69471_();
            }
        }
    }

    public static class OffscreenRenderer {
        private final Window window = EnvironmentManager.getClient().m_91268_();
        private final Stack<Buffer> allBuffers = new Stack();
        private final Stack<Buffer> reusableBuffers = new Stack();
        private final Stack<Group> allGroups = new Stack();

        public void push(@Nullable List<CGRect> rects) {
            Group group = this.appendList(rects);
            if (group == null) {
                return;
            }
            GL30.glDisable((int)3089);
            int mainTargetId = GL30.glGetInteger((int)36006);
            group.forEach((buffer, passes) -> {
                GL30.glBindFramebuffer((int)36009, (int)buffer.frameBufferId);
                buffer.init();
                passes.forEach(it -> buffer.blit(it.source, it.destination));
            });
            GL30.glBindFramebuffer((int)36009, (int)mainTargetId);
            GL30.glEnable((int)3089);
        }

        public void pop() {
            Group group = this.removeLast();
            if (group == null) {
                return;
            }
            int readTargetId = GL30.glGetInteger((int)36010);
            int drawTargetId = GL30.glGetInteger((int)36006);
            AbstractBufferSource buffers = AbstractBufferSource.tesselator();
            int mainTextureId = GL30.glGetFramebufferAttachmentParameteri((int)36008, (int)36064, (int)36049);
            GL30.glDisable((int)3089);
            GL30.glEnable((int)2960);
            GL30.glEnable((int)32925);
            group.forEach((buffer, passes) -> {
                GL30.glBindFramebuffer((int)36009, (int)buffer.frameBufferId);
                GL30.glStencilMask((int)255);
                GL30.glStencilFunc((int)519, (int)1, (int)255);
                GL30.glStencilOp((int)7681, (int)7681, (int)7681);
                IVertexConsumer maskBuilder = buffers.getBuffer(SkinRenderType.BLIT_MASK);
                passes.forEach(it -> buffer.mask(it.destination, maskBuilder));
                buffers.endBatch();
                GL30.glStencilFunc((int)514, (int)1, (int)255);
                GL30.glStencilOp((int)7680, (int)7680, (int)7680);
                RenderSystem.m_157453_((int)0, (int)mainTextureId);
                IVertexConsumer blitBuilder = buffers.getBuffer(SkinRenderType.BLIT_IMAGE);
                passes.forEach(it -> buffer.blit(it.source, it.destination, blitBuilder));
                buffers.endBatch();
                GL30.glBindFramebuffer((int)36009, (int)drawTargetId);
                GL30.glBindFramebuffer((int)36008, (int)buffer.frameBufferId);
                passes.forEach(it -> buffer.blit(it.destination, it.source));
                GL30.glBindFramebuffer((int)36008, (int)readTargetId);
            });
            group.clear();
            GL30.glDisable((int)32925);
            GL30.glDisable((int)2960);
            GL30.glEnable((int)3089);
        }

        @Nullable
        private Group appendList(@Nullable List<CGRect> rects) {
            Group group = null;
            if (rects != null && !rects.isEmpty()) {
                group = new Group();
                rects.forEach(group::add);
            }
            this.allGroups.add(group);
            return group;
        }

        @Nullable
        private Group removeLast() {
            if (!this.allGroups.isEmpty()) {
                return this.allGroups.pop();
            }
            return null;
        }

        private Buffer buffer() {
            if (this.allBuffers.isEmpty()) {
                return this.createBuffer();
            }
            return this.allBuffers.peek();
        }

        private void releaseBuffer(Buffer buffer) {
            this.allBuffers.remove(buffer);
            if (buffer.frameBufferId < 0) {
                return;
            }
            this.reusableBuffers.push(buffer);
        }

        private Buffer createBuffer() {
            int width = this.window.m_85441_();
            int height = this.window.m_85442_();
            while (!this.reusableBuffers.isEmpty()) {
                Buffer buffer = this.reusableBuffers.pop();
                if (buffer.frameWidth != width || height != buffer.frameHeight) {
                    buffer.release();
                    continue;
                }
                buffer.isDirty = true;
                this.allBuffers.push(buffer);
                return buffer;
            }
            float scale = (float)this.window.m_85449_();
            Buffer buffer = new Buffer(width, height, scale);
            this.allBuffers.push(buffer);
            return buffer;
        }

        public class Group {
            private Buffer defaultBuffer;
            private ArrayList<Pass> defaultPasses;
            private LinkedHashMap<Buffer, ArrayList<Pass>> otherPasses;

            public void add(CGRect rect) {
                Buffer buffer = OffscreenRenderer.this.buffer();
                Pass pass = buffer.add(rect);
                while (pass == null) {
                    buffer = OffscreenRenderer.this.createBuffer();
                    pass = buffer.add(rect);
                }
                this.getPassQueue(buffer).add(pass);
            }

            public void clear() {
                if (this.defaultBuffer != null) {
                    this.clearPassQueue(this.defaultBuffer, this.defaultPasses);
                    this.defaultPasses = null;
                    this.defaultBuffer = null;
                }
                if (this.otherPasses != null) {
                    this.otherPasses.forEach(this::clearPassQueue);
                    this.otherPasses = null;
                }
            }

            public void forEach(BiConsumer<Buffer, List<Pass>> consumer) {
                if (this.defaultBuffer != null) {
                    consumer.accept(this.defaultBuffer, this.defaultPasses);
                }
                if (this.otherPasses != null) {
                    this.otherPasses.forEach(consumer);
                }
            }

            private void clearPassQueue(Buffer buffer, ArrayList<Pass> passes) {
                passes.forEach(buffer::remove);
                if (buffer.isEmpty()) {
                    OffscreenRenderer.this.releaseBuffer(buffer);
                }
            }

            private ArrayList<Pass> getPassQueue(Buffer buffer) {
                if (this.defaultBuffer == null || this.defaultBuffer == buffer) {
                    if (this.defaultPasses == null) {
                        this.defaultBuffer = buffer;
                        this.defaultPasses = new ArrayList();
                    }
                    return this.defaultPasses;
                }
                if (this.otherPasses == null) {
                    this.otherPasses = new LinkedHashMap();
                }
                return this.otherPasses.computeIfAbsent(buffer, it -> new ArrayList());
            }
        }

        public static class Buffer {
            private final int frameWidth;
            private final int frameHeight;
            private final float frameScale;
            private boolean isDirty = true;
            private int frameBufferId = -1;
            private int colorBufferId = -1;
            private int renderBufferId = -1;
            private final BufferLine line;
            private final ArrayList<Pass> passes = new ArrayList();

            public Buffer(int width, int height, float scale) {
                this.frameWidth = width;
                this.frameHeight = height;
                this.line = new BufferLine(0, 0.0f, 0.0f, (float)width / scale, (float)height / scale);
                this.frameScale = scale;
                this.create(width, height);
            }

            public void blit(CGRect src, CGRect dst) {
                int fh = this.frameHeight;
                int sx0 = (int)(src.minX() * this.frameScale);
                int sx1 = (int)(src.maxX() * this.frameScale);
                int sy0 = (int)(src.minY() * this.frameScale);
                int sy1 = (int)(src.maxY() * this.frameScale);
                int dx0 = (int)(dst.minX() * this.frameScale);
                int dx1 = (int)(dst.maxX() * this.frameScale);
                int dy0 = (int)(dst.minY() * this.frameScale);
                int dy1 = (int)(dst.maxY() * this.frameScale);
                GL30.glBlitFramebuffer((int)sx0, (int)(fh - sy0), (int)sx1, (int)(fh - sy1), (int)dx0, (int)(fh - dy0), (int)dx1, (int)(fh - dy1), (int)16384, (int)9728);
            }

            public void blit(CGRect src, CGRect dst, IVertexConsumer buffer) {
                float sw = 1.0f / this.line.maxWidth;
                float sh = 1.0f / this.line.maxHeight;
                buffer.vertex(dst.minX(), dst.minY(), 1.0f).uv(src.minX() * sw, 1.0f - src.minY() * sh).color(255, 255, 255, 255).endVertex();
                buffer.vertex(dst.minX(), dst.maxY(), 1.0f).uv(src.minX() * sw, 1.0f - src.maxY() * sh).color(255, 255, 255, 255).endVertex();
                buffer.vertex(dst.maxX(), dst.maxY(), 1.0f).uv(src.maxX() * sw, 1.0f - src.maxY() * sh).color(255, 255, 255, 255).endVertex();
                buffer.vertex(dst.maxX(), dst.minY(), 1.0f).uv(src.maxX() * sw, 1.0f - src.minY() * sh).color(255, 255, 255, 255).endVertex();
            }

            public void mask(CGRect src, IVertexConsumer buffer) {
                float x = src.maxX();
                float y = src.maxY();
                float width = src.width();
                float height = src.height();
                float tx1 = 0.0f;
                float tx2 = 0.0f;
                float ty1 = 0.0f;
                float ty2 = 0.0f;
                float pi2 = 1.5707964f;
                int ts = (int)(pi2 * Math.abs(width));
                for (int idx = 0; idx <= ts; ++idx) {
                    float ap = pi2 * (float)idx / (float)ts;
                    tx1 = tx2;
                    ty1 = ty2;
                    tx2 = width * OpenMath.cos(ap);
                    ty2 = height * OpenMath.sin(ap);
                    if (idx < 1) continue;
                    buffer.vertex(x, y, 0.0f).color(255, 255, 255, 255).endVertex();
                    buffer.vertex(x - tx1, y - ty1, 0.0f).color(255, 255, 255, 255).endVertex();
                    buffer.vertex(x - tx2, y - ty2, 0.0f).color(255, 255, 255, 255).endVertex();
                }
            }

            public void init() {
                if (!this.isDirty) {
                    return;
                }
                this.isDirty = false;
                GL30.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL30.glClearStencil((int)0);
                GL30.glStencilMask((int)255);
                GL30.glClear((int)17664);
            }

            public void release() {
                GL30.glDeleteRenderbuffers((int)this.renderBufferId);
                GL30.glDeleteTextures((int)this.colorBufferId);
                GL30.glDeleteFramebuffers((int)this.frameBufferId);
                this.renderBufferId = -1;
                this.colorBufferId = -1;
                this.frameBufferId = -1;
            }

            @Nullable
            public Pass add(CGRect rect) {
                float height;
                float width = Math.min(Math.abs(rect.width()), this.line.maxWidth);
                Pass pass = this.line.add(width, height = Math.min(Math.abs(rect.height()), this.line.maxHeight), rect);
                if (pass != null) {
                    this.passes.add(pass);
                }
                return pass;
            }

            public void remove(Pass obj) {
                this.passes.remove(obj);
                this.line.remove(obj, null);
            }

            public boolean isEmpty() {
                return this.passes.isEmpty();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Buffer)) {
                    return false;
                }
                Buffer that = (Buffer)o;
                return this.frameBufferId == that.frameBufferId;
            }

            public int hashCode() {
                return this.frameBufferId;
            }

            private void create(int width, int height) {
                int oldFrameBufferId = GL30.glGetInteger((int)36006);
                this.frameBufferId = GL30.glGenFramebuffers();
                GL30.glBindFramebuffer((int)36160, (int)this.frameBufferId);
                this.colorBufferId = GL30.glGenTextures();
                GL30.glBindTexture((int)37120, (int)this.colorBufferId);
                GL32.glTexImage2DMultisample((int)37120, (int)4, (int)6407, (int)width, (int)height, (boolean)true);
                GL30.glBindTexture((int)37120, (int)0);
                GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)37120, (int)this.colorBufferId, (int)0);
                this.renderBufferId = GL30.glGenRenderbuffers();
                GL30.glBindRenderbuffer((int)36161, (int)this.renderBufferId);
                GL30.glRenderbufferStorageMultisample((int)36161, (int)4, (int)35056, (int)width, (int)height);
                GL30.glBindRenderbuffer((int)36161, (int)0);
                GL30.glFramebufferRenderbuffer((int)36160, (int)33306, (int)36161, (int)this.renderBufferId);
                int status = GL30.glCheckFramebufferStatus((int)36160);
                if (status != 36053) {
                    ModLog.debug("Framebuffer is not complete!", new Object[0]);
                }
                GL30.glBindFramebuffer((int)36160, (int)oldFrameBufferId);
            }
        }

        public static class Pass {
            public final CGRect source;
            public final CGRect destination;
            public final int lineId;

            public Pass(int lineNo, CGRect source, CGRect destination) {
                this.lineId = lineNo;
                this.source = source;
                this.destination = destination;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Pass)) {
                    return false;
                }
                Pass that = (Pass)o;
                return this.destination.equals(that.destination);
            }

            public int hashCode() {
                return this.destination.hashCode();
            }
        }

        public static class BufferLine {
            private float contentTop;
            private float contentLeft;
            private float contentWidth = 0.0f;
            private float contentHeight = 0.0f;
            private BufferLine next;
            private final int id;
            private final float maxWidth;
            private final float maxHeight;
            private final ArrayList<Pass> passes = new ArrayList();

            public BufferLine(int id, float left, float top, float maxWidth, float maxHeight) {
                this.id = id;
                this.contentTop = top;
                this.contentLeft = left;
                this.maxWidth = maxWidth;
                this.maxHeight = maxHeight;
            }

            @Nullable
            public Pass add(float width, float height, CGRect source) {
                if (this.next != null && height > this.contentHeight) {
                    return this.next.add(width, height, source);
                }
                if (this.contentTop + height > this.maxHeight) {
                    return null;
                }
                if (this.contentLeft + width <= this.maxWidth) {
                    CGRect destination = new CGRect(this.contentLeft, this.contentTop, width, height);
                    Pass pass = new Pass(this.id, source, destination);
                    this.contentLeft += width;
                    this.contentWidth += width;
                    this.contentHeight = Math.max(height, this.contentHeight);
                    this.passes.add(pass);
                    return pass;
                }
                if (this.contentTop + this.contentHeight + height > this.maxHeight) {
                    return null;
                }
                if (this.next == null) {
                    this.next = new BufferLine(this.id + 1, 0.0f, this.contentTop + this.contentHeight, this.maxWidth, this.maxHeight);
                }
                return this.next.add(width, height, source);
            }

            public void remove(Pass pass, @Nullable BufferLine parent) {
                if (pass.lineId != this.id) {
                    if (this.next != null) {
                        this.next.remove(pass, this);
                    }
                    return;
                }
                this.passes.remove(pass);
                if (this.passes.isEmpty()) {
                    this.contentLeft = 0.0f;
                    this.contentWidth = 0.0f;
                    this.contentHeight = 0.0f;
                    if (parent != null) {
                        parent.next = null;
                    }
                    return;
                }
                CGRect rect = pass.destination;
                this.contentWidth -= rect.width;
            }
        }
    }

    public static class Rectangle {
        protected final CGRect rect;

        public Rectangle(CGRect rect) {
            this.rect = rect;
        }

        @Nullable
        public List<CGRect> offscreenPasses() {
            return null;
        }
    }

    public static class RoundRectangle
    extends Rectangle {
        protected final float cornerRadius;

        public RoundRectangle(CGRect rect, float cornerRadius) {
            super(rect);
            this.cornerRadius = cornerRadius;
        }

        @Override
        public List<CGRect> offscreenPasses() {
            ArrayList<CGRect> passes = new ArrayList<CGRect>();
            passes.add(new CGRect(this.rect.minX(), this.rect.minY(), this.cornerRadius, this.cornerRadius));
            passes.add(new CGRect(this.rect.maxX(), this.rect.minY(), -this.cornerRadius, this.cornerRadius));
            passes.add(new CGRect(this.rect.maxX(), this.rect.maxY(), -this.cornerRadius, -this.cornerRadius));
            passes.add(new CGRect(this.rect.minX(), this.rect.maxY(), this.cornerRadius, -this.cornerRadius));
            return passes;
        }
    }
}

