/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.impl.InvokerResult;
import com.apple.library.impl.TextInputTraits;
import com.apple.library.impl.WindowDispatcherImpl;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.Predicate;

public class WindowManagerImpl {
    private boolean isCalledInit = false;
    private CGSize lastLayoutSize;
    private double lastMouseX;
    private double lastMouseY;
    private int lastMouseButton;
    private int lastFocusVersion = 0;
    private int lastFocusVersionOld = 0;
    protected final Queue<WindowDispatcherImpl> dispatchers = new Queue();

    public WindowManagerImpl() {
        this.dispatchers.add(WindowDispatcherImpl.BACKGROUND);
        this.dispatchers.add(WindowDispatcherImpl.FOREGROUND);
        this.dispatchers.add(WindowDispatcherImpl.OVERLAY);
    }

    public void init() {
        this.dispatchers.forEach(WindowDispatcherImpl::init);
        this.isCalledInit = true;
    }

    public void deinit() {
        this.dispatchers.forEach(WindowDispatcherImpl::deinit);
        this.dispatchers.removeAll();
    }

    public void addWindow(UIWindow window) {
        UIWindow.Dispatcher dispatcher = new UIWindow.Dispatcher(window);
        this.dispatchers.add(dispatcher);
        if (this.isCalledInit) {
            dispatcher.init();
        }
        if (this.lastLayoutSize != null) {
            dispatcher.layout(this.lastLayoutSize);
        }
        this._setNeedsUpdateFocus();
    }

    public void removeWindow(UIWindow window) {
        this.dispatchers.removeIf(dispatcher -> {
            if (dispatcher instanceof UIWindow.Dispatcher) {
                UIWindow.Dispatcher windowDispatcher = (UIWindow.Dispatcher)dispatcher;
                if (windowDispatcher.window == window) {
                    windowDispatcher.deinit();
                    return true;
                }
            }
            return false;
        });
        this._setNeedsUpdateFocus();
    }

    public void _setNeedsUpdateFocus() {
        ++this.lastFocusVersion;
    }

    public void tick() {
        this.updateLastFocusIfNeeded();
        this.dispatchers.forEach(WindowDispatcherImpl::tick);
    }

    public void layout(float width, float height) {
        CGSize size = new CGSize(width, height);
        this.dispatchers.forEach(dispatcher -> dispatcher.layout(size));
        this.lastLayoutSize = size;
    }

    public void render(CGGraphicsContext context, RenderInvoker foreground, RenderInvoker background, RenderInvoker overlay) {
        float partialTicks = context.state().partialTicks();
        int mouseX = (int)context.state().mousePos().x();
        int mouseY = (int)context.state().mousePos().y();
        UIView tooltipResponder = this.firstTooltipResponder();
        if (tooltipResponder != null) {
            mouseX = Integer.MIN_VALUE;
            mouseY = Integer.MIN_VALUE;
        }
        for (WindowDispatcherImpl dispatcher : this.dispatchers) {
            dispatcher.render(context);
            if (dispatcher == WindowDispatcherImpl.BACKGROUND) {
                background.invoke(mouseX, mouseY, partialTicks, context);
            }
            if (dispatcher == WindowDispatcherImpl.FOREGROUND) {
                foreground.invoke(mouseX, mouseY, partialTicks, context);
            }
            if (dispatcher != WindowDispatcherImpl.OVERLAY) continue;
            overlay.invoke(mouseX, mouseY, partialTicks, context);
            this.renderTooltip(tooltipResponder, context);
        }
    }

    private void renderTooltip(UIView tooltipResponder, CGGraphicsContext context) {
        if (tooltipResponder == null) {
            return;
        }
        Object tooltip = tooltipResponder.tooltip();
        if (tooltip != null) {
            context.saveGraphicsState();
            context.translateCTM(0.0f, 0.0f, 400.0f);
            context.drawTooltip(tooltip, tooltipResponder.bounds());
            context.restoreGraphicsState();
        }
    }

    private void updateLastFocus(double mouseX, double mouseY, int button) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.lastMouseButton = button;
        this.lastFocusVersionOld = this.lastFocusVersion;
    }

    private void updateLastFocusIfNeeded() {
        if (this.lastFocusVersion != this.lastFocusVersionOld) {
            this.mouseMoved(this.lastMouseX, this.lastMouseY, this.lastMouseButton, (mouseX, mouseY, button) -> true);
        }
    }

    public boolean keyUp(int key, int i, int j, Invoker<Integer, Integer, Integer, Boolean> invoker) {
        return this.dispatchers.invoke(key, i, j, invoker, WindowDispatcherImpl::keyUp);
    }

    public boolean keyDown(int key, int i, int j, Invoker<Integer, Integer, Integer, Boolean> invoker) {
        return this.dispatchers.invoke(key, i, j, invoker, WindowDispatcherImpl::keyDown);
    }

    public boolean charTyped(int key, int i, int j, Invoker<Integer, Integer, Integer, Boolean> invoker) {
        return this.dispatchers.invoke(key, i, j, invoker, WindowDispatcherImpl::charTyped);
    }

    public boolean mouseDown(double mouseX, double mouseY, int button, Invoker<Double, Double, Integer, Boolean> invoker) {
        return this.dispatchers.invoke(mouseX, mouseY, button, invoker, WindowDispatcherImpl::mouseDown);
    }

    public boolean mouseUp(double mouseX, double mouseY, int button, Invoker<Double, Double, Integer, Boolean> invoker) {
        return this.dispatchers.invoke(mouseX, mouseY, button, invoker, WindowDispatcherImpl::mouseUp);
    }

    public boolean mouseMoved(double mouseX, double mouseY, int button, Invoker<Double, Double, Integer, Boolean> invoker) {
        this.updateLastFocus(mouseX, mouseY, button);
        return this.dispatchers.invoke(mouseX, mouseY, button, invoker, WindowDispatcherImpl::mouseMoved);
    }

    public boolean mouseWheel(double mouseX, double mouseY, CGPoint delta, Invoker<Double, Double, CGPoint, Boolean> invoker) {
        return this.dispatchers.invoke(mouseX, mouseY, delta, invoker, WindowDispatcherImpl::mouseWheel);
    }

    public boolean mouseIsInside(double mouseX, double mouseY, int button) {
        return this.dispatchers.test(dispatcher -> dispatcher.mouseIsInside(mouseX, mouseY, button));
    }

    public boolean changeKeyView(boolean bl) {
        return this.dispatchers.test(dispatcher -> dispatcher.changeKeyView(bl));
    }

    public UIView firstTooltipResponder() {
        return this.dispatchers.flatMap(WindowDispatcherImpl::firstTooltipResponder);
    }

    public UIView firstInputResponder() {
        return this.dispatchers.flatMap(WindowDispatcherImpl::firstInputResponder);
    }

    public boolean isTextEditing() {
        return this.firstInputResponder() instanceof TextInputTraits;
    }

    public static class Queue<T extends WindowDispatcherImpl>
    implements Iterable<T> {
        private final LinkedList<T> values = new LinkedList();
        private LinkedList<T> readValues = this.values;

        public void add(T val) {
            this.values.add(val);
            this.values.sort(Comparator.comparing(WindowDispatcherImpl::level));
            this.readValues = new LinkedList<T>(this.values);
        }

        public void remove(T val) {
            this.values.remove(val);
            this.readValues = new LinkedList<T>(this.values);
        }

        public void removeIf(Predicate<T> val) {
            this.values.removeIf(val);
            this.readValues = new LinkedList<T>(this.values);
        }

        public void removeAll() {
            this.values.clear();
            this.readValues = new LinkedList<T>(this.values);
        }

        public boolean test(Function<T, InvokerResult> provider) {
            for (WindowDispatcherImpl value : this.descendingEnum()) {
                InvokerResult result = provider.apply(value);
                if (!result.isDecided()) continue;
                return result.conclusion();
            }
            return false;
        }

        public <U> U flatMap(Function<T, U> provider) {
            for (WindowDispatcherImpl value : this.descendingEnum()) {
                U ret = provider.apply(value);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        public <A, B, C> boolean invoke(A a, B b, C c, Invoker<A, B, C, Boolean> invoker, Invoker4<T, A, B, C, InvokerResult> provider) {
            for (WindowDispatcherImpl value : this.descendingEnum()) {
                InvokerResult ret = provider.invoke((T)value, (WindowDispatcherImpl)a, (A)b, (B)c);
                if (!ret.isDecided()) continue;
                return ret.conclusion();
            }
            return invoker.invoke(a, b, c);
        }

        @Override
        public Iterator<T> iterator() {
            return this.readValues.iterator();
        }

        public Iterable<T> descendingEnum() {
            return this.readValues::descendingIterator;
        }
    }

    @FunctionalInterface
    public static interface RenderInvoker {
        public void invoke(int var1, int var2, float var3, CGGraphicsContext var4);
    }

    @FunctionalInterface
    public static interface Invoker<A, B, C, U> {
        public U invoke(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface Invoker4<A, B, C, D, U> {
        public U invoke(A var1, B var2, C var3, D var4);
    }
}

