/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSRange;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextPosition;
import com.apple.library.foundation.NSTextRange;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.DelegateImpl;
import com.apple.library.impl.TextInputImpl;
import com.apple.library.impl.TextInputTraits;
import com.apple.library.impl.TextStorageImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UITextViewDelegate;
import com.apple.library.uikit.UIWindow;

public class UITextView
extends UIScrollView
implements TextInputTraits {
    private final TextStorageImpl storage = new TextStorageImpl();
    private final TextInputImpl input = new TextInputImpl(this.storage);
    private final DelegateImpl<UITextViewDelegate> delegate = DelegateImpl.of(new UITextViewDelegate(){});
    private UIEdgeInsets contentInsets = new UIEdgeInsets(8.0f, 4.0f, 8.0f, 4.0f);
    private boolean isBordered = true;
    private boolean needSyncCursor = false;

    public UITextView(CGRect frame) {
        super(frame);
        this.storage.setLineSpacing(1);
        this.storage.maxLength = 32;
        this.storage.sizeDidChange = this::sizeDidChange;
        this.storage.selectionDidChange = this::selectionDidChange;
        this.storage.valueDidChange = this::valueDidChange;
        this.storage.valueShouldChange = this::valueShouldChange;
        this.input.returnHandler = this::shouldReturn;
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect bounds = this.bounds().insetBy(this.contentInsets);
        this.storage.setBoundingSize(new CGSize(bounds.width, bounds.height));
    }

    @Override
    public void mouseDown(UIEvent event) {
        if (!this.storage.isFocused()) {
            this.becomeFirstResponder();
        }
        if (this.shouldInputText()) {
            this.input.mouseDown(event.locationInView(this));
        }
    }

    @Override
    public void keyDown(UIEvent event) {
        if (this.shouldInputText() && this.input.keyDown(event.key)) {
            return;
        }
        if (this.isFocused() && event.key == 256) {
            this.resignFirstResponder();
            return;
        }
        super.keyDown(event);
    }

    @Override
    public void charTyped(UIEvent event) {
        if (this.shouldInputText() && this.input.charTyped((char)event.key)) {
            return;
        }
        super.charTyped(event);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        CGRect bounds = this.bounds();
        CGRect fixedBounds = bounds.insetBy(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.isBordered) {
            context.fillRect(bounds, this.borderColor());
            context.fillRect(fixedBounds, this.fillColor());
        }
        context.addClip(UIScreen.convertRectFromView(fixedBounds, this));
        this.storage.render(point, context);
        context.removeClip();
    }

    public boolean isEditable() {
        return this.input.isEditable();
    }

    public void setEditable(boolean isEditable) {
        this.input.setEditable(isEditable);
    }

    public UIFont font() {
        return this.storage.font();
    }

    public void setFont(UIFont font) {
        this.storage.setFont(font);
    }

    public NSString placeholder() {
        return this.storage.placeholder();
    }

    public void setPlaceholder(NSString placeholder) {
        this.storage.setPlaceholder(placeholder);
    }

    public UIColor placeholderColor() {
        return this.storage.placeholderColor();
    }

    public void setPlaceholderColor(UIColor placeholderColor) {
        this.storage.setPlaceholderColor(placeholderColor);
    }

    public String text() {
        return this.storage.value();
    }

    public void setText(String text) {
        this.storage.setValue(text);
        this.storage.checkCursorAndHighlightPos();
    }

    public UIColor textColor() {
        return this.storage.textColor();
    }

    public void setTextColor(UIColor textColor) {
        this.storage.setTextColor(textColor);
    }

    public NSTextRange selectedTextRange() {
        return this.storage.selectedTextRange();
    }

    public void setSelectedTextRange(NSTextRange range) {
        this.storage.setSelectedTextRange(range);
    }

    @Override
    public UITextViewDelegate delegate() {
        return this.delegate.get();
    }

    public void setDelegate(UITextViewDelegate delegate) {
        this.delegate.set(delegate);
    }

    public boolean isEditing() {
        return this.storage.isFocused();
    }

    @Override
    public void becomeFirstResponder() {
        if (this.storage.isFocused() || !this.isEditable()) {
            return;
        }
        UIWindow window = this.window();
        if (window != null) {
            if (!this.delegate.invoker().textViewShouldBeginEditing(this)) {
                return;
            }
            window.setFirstInputResponder(this);
            this.storage.setFocused(true);
            this.delegate.invoker().textViewDidBeginEditing(this);
        }
    }

    @Override
    public void resignFirstResponder() {
        if (!this.storage.isFocused()) {
            return;
        }
        if (!this.delegate.invoker().textViewShouldEndEditing(this)) {
            return;
        }
        UIWindow window = this.window();
        if (window != null) {
            window.setFirstInputResponder(null);
        }
        this.storage.setFocused(false);
        this.delegate.invoker().textViewDidEndEditing(this);
    }

    @Override
    public boolean canBecomeFocused() {
        return !this._ignoresTouchEvents(this) && this.input.isEditable();
    }

    public NSTextPosition beginOfDocument() {
        return this.storage.beginOfDocument();
    }

    public NSTextPosition endOfDocument() {
        return this.storage.endOfDocument();
    }

    public int maxLength() {
        return this.storage.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.storage.maxLength = maxLength;
    }

    @Override
    public UIEdgeInsets contentInsets() {
        return this.contentInsets;
    }

    @Override
    public void setContentInsets(UIEdgeInsets contentInsets) {
        this.contentInsets = contentInsets;
    }

    private boolean shouldReturn(String value) {
        return true;
    }

    private boolean valueShouldChange(NSRange range, String newValue) {
        return this.delegate.invoker().textViewShouldChangeText(this, range, newValue);
    }

    private void valueDidChange(String oldValue, String newValue) {
        this.delegate.invoker().textViewDidChange(this);
    }

    private void selectionDidChange() {
        this.delegate.invoker().textViewDidChangeSelection(this);
        this.needSyncCursor = true;
    }

    private void sizeDidChange(CGRect rect, CGSize size) {
        float height = size.height + this.contentInsets.top + this.contentInsets.bottom;
        if (this.contentSize.height != height) {
            this.storage.offset = new CGPoint(this.contentInsets.left, this.contentInsets.top);
            this.setContentSize(new CGSize(0.0f, height));
        }
        if (this.needSyncCursor) {
            this.needSyncCursor = false;
            CGRect box = this.convertRectToView(rect, this.superview());
            CGRect frame = this.frame().insetBy(this.contentInsets);
            if (box.minY() < frame.minY() || box.maxY() > frame.maxY()) {
                this.setContentOffset(new CGPoint(0.0f, rect.y));
            }
        }
    }

    private UIColor fillColor() {
        return AppearanceImpl.TEXT_BACKGROUND_COLOR;
    }

    private UIColor borderColor() {
        if (this.storage.isFocused()) {
            return AppearanceImpl.TEXT_FOCUSED_BORDER_COLOR;
        }
        return AppearanceImpl.TEXT_BORDER_COLOR;
    }

    private boolean shouldInputText() {
        return !this.isHidden() && this.storage.isFocused() && this.isUserInteractionEnabled() && this.isEditable();
    }
}

