/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinLoadException;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ArmourerMenu
extends AbstractBlockEntityMenu<ArmourerBlockEntity> {
    private final SimpleContainer inventory = new SimpleContainer(4);
    private Group group = null;

    public ArmourerMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.addPlayerSlots((Container)playerInventory, 8, 142, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addCustomSlot((Container)this.inventory, 0, 64, 21);
        this.addCustomSlot((Container)this.inventory, 1, 147, 21);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, (Container)this.inventory);
    }

    public boolean shouldLoadArmourItem(Player player) {
        ItemStack stackInput = this.inventory.m_8020_(0);
        ItemStack stackOutput = this.inventory.m_8020_(1);
        if (stackInput.m_41619_() || !stackOutput.m_41619_()) {
            return false;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        return !descriptor.isEmpty();
    }

    public boolean shouldSaveArmourItem(Player player) {
        ItemStack stackInput = this.inventory.m_8020_(0);
        ItemStack stackOutput = this.inventory.m_8020_(1);
        if (player.m_7500_() && stackInput.m_41619_()) {
            stackInput = new ItemStack((ItemLike)ModItems.SKIN_TEMPLATE.get());
        }
        return !stackInput.m_41619_() && stackOutput.m_41619_();
    }

    public void saveArmourItem(Player player, GameProfile profile, String customName, String tags) {
        if (!this.shouldSaveArmourItem(player)) {
            return;
        }
        if (((ArmourerBlockEntity)this.blockEntity).m_58904_() == null || ((ArmourerBlockEntity)this.blockEntity).m_58904_().m_5776_()) {
            return;
        }
        try {
            ItemStack stackInput = this.inventory.m_8020_(0);
            SkinProperties skinProps = ((ArmourerBlockEntity)this.blockEntity).skinProperties().copy();
            skinProps.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
            if (profile.getId() != null) {
                skinProps.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
            }
            if (customName != null) {
                skinProps.put(SkinProperty.ALL_CUSTOM_NAME, customName);
            }
            Level level = ((ArmourerBlockEntity)this.blockEntity).m_58904_();
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            Skin skin = WorldUtils.saveSkinFromWorld(level, transform, skinProps, ((ArmourerBlockEntity)this.blockEntity).skinType(), ((ArmourerBlockEntity)this.blockEntity).paintData());
            String identifier = SkinLoader.getInstance().saveSkin("", skin);
            SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.type());
            if (!player.m_7500_()) {
                stackInput.m_41774_(1);
            }
            this.inventory.m_6836_(1, descriptor.asItemStack());
        }
        catch (TranslatableException exception) {
            SystemMessageProvider.sendSystemMessage(player, exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadArmourItem(Player player) {
        if (((ArmourerBlockEntity)this.blockEntity).m_58904_() == null || ((ArmourerBlockEntity)this.blockEntity).m_58904_().m_5776_()) {
            return;
        }
        ItemStack stackInput = this.inventory.m_8020_(0);
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        if (!this.shouldLoadArmourItem(player)) {
            return;
        }
        try {
            Skin skin = SkinLoader.getInstance().loadSkin(descriptor.identifier());
            if (skin == null) {
                throw SkinLoadException.Type.NOT_FOUND.build("notFound", new Object[0]);
            }
            if (skin.type() != ((ArmourerBlockEntity)this.blockEntity).skinType()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_TYPE.build("notSupportType", new Object[0]);
            }
            if (!skin.isBasicOnly()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_CONTENT.build("notSupportContent", new Object[0]);
            }
            if (!skin.settings().isEditable()) {
                throw SkinLoadException.Type.NOT_EDITABLE.build("notEditable", new Object[0]);
            }
            ((ArmourerBlockEntity)this.blockEntity).setSkinProperties(skin.properties());
            ((ArmourerBlockEntity)this.blockEntity).setPaintData(skin.paintData());
            CubeChangesCollector collector = new CubeChangesCollector(((ArmourerBlockEntity)this.blockEntity).m_58904_());
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            WorldUtils.loadSkinIntoWorld(collector, transform, skin);
            collector.submit((Component)TranslatableProvider.translatable(Component.class, "action.armourers_workshop.block.load", new Object[0]), player);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            this.inventory.m_6836_(1, stackInput);
        }
        catch (TranslatableException exception) {
            SystemMessageProvider.sendSystemMessage(player, exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        return this.quickMoveStack(player, index, this.f_38839_.size() - 1);
    }

    protected void addCustomSlot(Container inventory, final int slot, int x, int y) {
        this.m_38897_(new GroupSlot(inventory, slot, x, y){

            public boolean m_5857_(ItemStack itemStack) {
                if (slot == 0) {
                    if (itemStack.m_150930_((Item)ModItems.SKIN_TEMPLATE.get())) {
                        return true;
                    }
                    return !SkinDescriptor.of(itemStack).isEmpty();
                }
                return false;
            }
        });
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public boolean shouldRenderInventory() {
        return this.group == Group.MAIN;
    }

    public static enum Group {
        MAIN,
        SKIN,
        DISPLAY,
        BLOCK;

    }

    public class GroupSlot
    extends Slot {
        public GroupSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean m_6659_() {
            return ArmourerMenu.this.shouldRenderInventory();
        }
    }
}

