/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdvancedImportPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Skin skin;
    private final String target;

    public AdvancedImportPacket(AdvancedBuilderBlockEntity blockEntity, Skin skin, String target) {
        this.pos = blockEntity.m_58899_();
        this.skin = skin;
        this.target = target;
    }

    public AdvancedImportPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.target = buffer.readUtf();
        this.skin = this.decodeSkin(buffer);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.target);
        this.encodeSkin(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        AdvancedBuilderBlockEntity blockEntity1;
        block10: {
            block9: {
                BlockEntity blockEntity = player.m_183503_().m_7702_(this.pos);
                if (!(blockEntity instanceof AdvancedBuilderBlockEntity)) break block9;
                blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
                if (player.f_36096_ instanceof AdvancedBuilderMenu && this.skin != null) break block10;
            }
            this.abort((Player)player, "unauthorized", "user status is incorrect or the skin is invalid");
            return;
        }
        SkinLibraryManager.Server server = SkinLibraryManager.getServer();
        if (!server.shouldUploadFile((Player)player)) {
            this.abort((Player)player, "import", "uploading prohibited in the config file");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_IMPORT.accept((Player)player)) {
            this.abort((Player)player, "import", "prohibited by the config file");
            return;
        }
        if (!this.skin.settings().isEditable()) {
            this.abort((Player)player, "import", "prohibited by the skin can't editing.");
            return;
        }
        SkinDocumentNode node = null;
        if (!this.target.isEmpty() && (node = blockEntity1.document().nodeById(this.target)) == null) {
            this.abort((Player)player, "import", "can't found node.");
            return;
        }
        this.accept((Player)player, "import");
        String identifier = SkinLoader.getInstance().saveSkin("", this.skin);
        if (node != null) {
            blockEntity1.importToNode(identifier, this.skin, node);
        } else {
            blockEntity1.importToDocument(identifier, this.skin);
        }
    }

    private void accept(Player player, String op) {
        ModLog.info("accept {} request of the '{}'", op, player.m_6302_());
    }

    private void abort(Player player, String op, String reason) {
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, player.m_6302_(), reason);
    }

    private void encodeSkin(IFriendlyByteBuf buffer) {
        try (GZIPOutputStream outputStream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream(buffer.asByteBuf()));){
            SkinSerializer.writeToStream(this.skin, null, outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Skin decodeSkin(IFriendlyByteBuf buffer) {
        Skin skin;
        GZIPInputStream inputStream = new GZIPInputStream((InputStream)new ByteBufInputStream(buffer.asByteBuf()));
        try {
            skin = SkinSerializer.readFromStream(null, inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        inputStream.close();
        return skin;
    }
}

