/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.core.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.core.data.cache.ObjectPool;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractPoseStackImpl {
    protected static final ObjectPool<OpenPoseStack> REUSABLE_QUEUE = ObjectPool.create(OpenPoseStack::new);
    private static final AbstractMatrix3f CONVERTER_MAT3 = new AbstractMatrix3f(new Matrix3f());
    private static final AbstractMatrix4f CONVERTER_MAT4 = new AbstractMatrix4f(new Matrix4f());
    private static final Quaternion CONVERTER_QUAT = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private static final FloatBuffer BUFFER3x3 = MatrixUtils.createFloatBuffer(9);
    private static final FloatBuffer BUFFER4x4 = MatrixUtils.createFloatBuffer(16);

    public static Matrix3f convertMatrix(IMatrix3f mat) {
        AbstractMatrix3f newValue = Objects.safeCast(mat, AbstractMatrix3f.class);
        if (newValue != null) {
            return newValue.mat;
        }
        mat.store(BUFFER3x3);
        CONVERTER_MAT3.load(BUFFER3x3);
        return AbstractPoseStackImpl.CONVERTER_MAT3.mat;
    }

    public static Matrix4f convertMatrix(IMatrix4f mat) {
        AbstractMatrix4f newValue = Objects.safeCast(mat, AbstractMatrix4f.class);
        if (newValue != null) {
            return newValue.mat;
        }
        mat.store(BUFFER4x4);
        CONVERTER_MAT4.load(BUFFER4x4);
        return AbstractPoseStackImpl.CONVERTER_MAT4.mat;
    }

    public static Quaternion convertQuaternion(IQuaternionf q) {
        CONVERTER_QUAT.m_80143_(q.x(), q.y(), q.z(), q.w());
        return CONVERTER_QUAT;
    }

    public static Quaternion copyQuaternion(IQuaternionf q) {
        return new Quaternion(q.x(), q.y(), q.z(), q.w());
    }

    public static class AbstractMatrix3f
    implements IMatrix3f {
        private final Matrix3f mat;

        public AbstractMatrix3f(Matrix3f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.f_8134_ = buffer.get(this.bufferIndex(0, 0));
            this.mat.f_8135_ = buffer.get(this.bufferIndex(0, 1));
            this.mat.f_8136_ = buffer.get(this.bufferIndex(0, 2));
            this.mat.f_8137_ = buffer.get(this.bufferIndex(1, 0));
            this.mat.f_8138_ = buffer.get(this.bufferIndex(1, 1));
            this.mat.f_8139_ = buffer.get(this.bufferIndex(1, 2));
            this.mat.f_8140_ = buffer.get(this.bufferIndex(2, 0));
            this.mat.f_8141_ = buffer.get(this.bufferIndex(2, 1));
            this.mat.f_8142_ = buffer.get(this.bufferIndex(2, 2));
        }

        @Override
        public void store(FloatBuffer buffer) {
            buffer.put(this.bufferIndex(0, 0), this.mat.f_8134_);
            buffer.put(this.bufferIndex(0, 1), this.mat.f_8135_);
            buffer.put(this.bufferIndex(0, 2), this.mat.f_8136_);
            buffer.put(this.bufferIndex(1, 0), this.mat.f_8137_);
            buffer.put(this.bufferIndex(1, 1), this.mat.f_8138_);
            buffer.put(this.bufferIndex(1, 2), this.mat.f_8139_);
            buffer.put(this.bufferIndex(2, 0), this.mat.f_8140_);
            buffer.put(this.bufferIndex(2, 1), this.mat.f_8141_);
            buffer.put(this.bufferIndex(2, 2), this.mat.f_8142_);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.m_8178_(Matrix3f.m_8174_((float)x, (float)y, (float)z));
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.m_8171_(AbstractPoseStackImpl.convertQuaternion(q));
        }

        @Override
        public void set(IMatrix3f matrix) {
            matrix.store(BUFFER3x3);
            this.load(BUFFER3x3);
        }

        public void set(IMatrix4f matrix) {
            FloatBuffer buffer = BUFFER4x4;
            matrix.store(buffer);
            this.mat.f_8134_ = buffer.get(this.bufferIndex4(0, 0));
            this.mat.f_8135_ = buffer.get(this.bufferIndex4(0, 1));
            this.mat.f_8136_ = buffer.get(this.bufferIndex4(0, 2));
            this.mat.f_8137_ = buffer.get(this.bufferIndex4(1, 0));
            this.mat.f_8138_ = buffer.get(this.bufferIndex4(1, 1));
            this.mat.f_8139_ = buffer.get(this.bufferIndex4(1, 2));
            this.mat.f_8140_ = buffer.get(this.bufferIndex4(2, 0));
            this.mat.f_8141_ = buffer.get(this.bufferIndex4(2, 1));
            this.mat.f_8142_ = buffer.get(this.bufferIndex4(2, 2));
        }

        @Override
        public void multiply(IMatrix3f matrix) {
            this.mat.m_8178_(AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector3f vec = new Vector3f(values[0], values[1], values[2]);
            vec.m_122249_(this.mat);
            values[0] = vec.m_122239_();
            values[1] = vec.m_122260_();
            values[2] = vec.m_122269_();
        }

        @Override
        public void invert() {
            this.mat.m_8187_();
        }

        @Override
        public void transpose() {
            this.mat.m_8155_();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractMatrix3f)) {
                return false;
            }
            AbstractMatrix3f that = (AbstractMatrix3f)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }

        private int bufferIndex(int i, int j) {
            return j * 3 + i;
        }

        private int bufferIndex4(int i, int j) {
            return j * 4 + i;
        }
    }

    public static class AbstractMatrix4f
    implements IMatrix4f {
        private final Matrix4f mat;

        public AbstractMatrix4f(Matrix4f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.f_27603_ = buffer.get(this.bufferIndex(0, 0));
            this.mat.f_27604_ = buffer.get(this.bufferIndex(0, 1));
            this.mat.f_27605_ = buffer.get(this.bufferIndex(0, 2));
            this.mat.f_27606_ = buffer.get(this.bufferIndex(0, 3));
            this.mat.f_27607_ = buffer.get(this.bufferIndex(1, 0));
            this.mat.f_27608_ = buffer.get(this.bufferIndex(1, 1));
            this.mat.f_27609_ = buffer.get(this.bufferIndex(1, 2));
            this.mat.f_27610_ = buffer.get(this.bufferIndex(1, 3));
            this.mat.f_27611_ = buffer.get(this.bufferIndex(2, 0));
            this.mat.f_27612_ = buffer.get(this.bufferIndex(2, 1));
            this.mat.f_27613_ = buffer.get(this.bufferIndex(2, 2));
            this.mat.f_27614_ = buffer.get(this.bufferIndex(2, 3));
            this.mat.f_27615_ = buffer.get(this.bufferIndex(3, 0));
            this.mat.f_27616_ = buffer.get(this.bufferIndex(3, 1));
            this.mat.f_27617_ = buffer.get(this.bufferIndex(3, 2));
            this.mat.f_27618_ = buffer.get(this.bufferIndex(3, 3));
        }

        @Override
        public void store(FloatBuffer buffer) {
            buffer.put(this.bufferIndex(0, 0), this.mat.f_27603_);
            buffer.put(this.bufferIndex(0, 1), this.mat.f_27604_);
            buffer.put(this.bufferIndex(0, 2), this.mat.f_27605_);
            buffer.put(this.bufferIndex(0, 3), this.mat.f_27606_);
            buffer.put(this.bufferIndex(1, 0), this.mat.f_27607_);
            buffer.put(this.bufferIndex(1, 1), this.mat.f_27608_);
            buffer.put(this.bufferIndex(1, 2), this.mat.f_27609_);
            buffer.put(this.bufferIndex(1, 3), this.mat.f_27610_);
            buffer.put(this.bufferIndex(2, 0), this.mat.f_27611_);
            buffer.put(this.bufferIndex(2, 1), this.mat.f_27612_);
            buffer.put(this.bufferIndex(2, 2), this.mat.f_27613_);
            buffer.put(this.bufferIndex(2, 3), this.mat.f_27614_);
            buffer.put(this.bufferIndex(3, 0), this.mat.f_27615_);
            buffer.put(this.bufferIndex(3, 1), this.mat.f_27616_);
            buffer.put(this.bufferIndex(3, 2), this.mat.f_27617_);
            buffer.put(this.bufferIndex(3, 3), this.mat.f_27618_);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.m_27644_(Matrix4f.m_27632_((float)x, (float)y, (float)z));
        }

        @Override
        public void translate(float x, float y, float z) {
            this.mat.m_27648_(new Vector3f(x, y, z));
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.m_27646_(AbstractPoseStackImpl.convertQuaternion(q));
        }

        @Override
        public void set(IMatrix4f matrix) {
            matrix.store(BUFFER4x4);
            this.load(BUFFER4x4);
        }

        @Override
        public void multiply(IMatrix4f matrix) {
            this.mat.m_27644_(AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector4f vec = new Vector4f(values[0], values[1], values[2], values[3]);
            vec.m_123607_(this.mat);
            values[0] = vec.m_123601_();
            values[1] = vec.m_123615_();
            values[2] = vec.m_123616_();
            values[3] = vec.m_123617_();
        }

        @Override
        public void invert() {
            this.mat.m_27657_();
        }

        @Override
        public void transpose() {
            this.mat.m_27659_();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractMatrix4f)) {
                return false;
            }
            AbstractMatrix4f that = (AbstractMatrix4f)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }

        private int bufferIndex(int i, int j) {
            return j * 4 + i;
        }
    }
}

